package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;

import java.util.Date;

/**
 * 
 * 订单信息表
 * 
 * @author LinQingLin
 * @date 2017年4月6日 下午2:58:55
 * @注意事项 </b>
 * <b>
 */
public class Order extends BaseModel{

    /**  */
	private static final long serialVersionUID = 545418334393807629L;

	/**
    * 用户ID
    */
    @ModelAnnotation(getName="用户ID",column = "user_id")
    private Long userid;

    /**
    * 订单号
    */
    @ModelAnnotation(getName="订单号",column = "ordernumber")
    private String ordernumber;

    /**
     * 随机订单号 防止不同环境调银联支付平台订单重复问题
     */
    @ModelAnnotation(getName="随机订单号",column = "random_orderno")
    private String randomOrderNo;
    /**
    * 付款状态 1待付款2付款成功3异常
    */
    @ModelAnnotation(getName="付款状态",column = "paystate")
    private String paystate;

    /**
    * 订单有效开始时间
    */
    @ModelAnnotation(getName="订单有效开始时间",column = "effectivestarttime")
    private Date effectivestarttime;

    /**
    * 订单有效结束时间
    */
    @ModelAnnotation(getName="订单有效结束时间",column = "effectiveendtime")
    private Date effectiveendtime;

    /**
    * 发票信息名称
    */
    @ModelAnnotation(getName="发票信息名称",column = "invoicename")
    private String invoicename;

    /**
    * 发票信息ID
    */
    @ModelAnnotation(getName="发票信息ID",column = "invoiceid")
    private Long invoiceid;

    /**
    * 寄送地址
    */
    @ModelAnnotation(getName="寄送地址",column = "sendaddress")
    private String sendaddress;

    /**
    * 签收人
    */
    @ModelAnnotation(getName="签收人",column = "signatory")
    private String signatory;

    /**
    * 联系电话
    */
    @ModelAnnotation(getName="联系电话",column = "tel")
    private String tel;

    /**
    * 商品名称
    */
    @ModelAnnotation(getName="商品名称",column = "goodsname")
    private String goodsname;

    /**
    * 单价
    */
    @ModelAnnotation(getName="单价",column = "unitprice")
    private String unitprice;

    /**
    * 购买数量
    */
    @ModelAnnotation(getName="购买数量",column = "countnumber")
    private Integer countnumber;

    /**
    * 金额
    */
    @ModelAnnotation(getName="金额",column = "amount")
    private String amount;

    /**
    * 其他
    */
    @ModelAnnotation(getName="其他",column = "remarks")
    private String remarks;

    /**
    * 培训机构ID
    */
    @ModelAnnotation(getName="培训机构ID",column = "trainorgid")
    private Long trainorgid;

    /**
    * 购买保安公司名称
    */
    @ModelAnnotation(getName="购买保安公司名称",column = "companyname")
    private String companyname;

    /**
    * 培训类型 1、初级保安员课程 2、任务管理+继续再教育课程 8、保安员资格证培训课程
    */
    @ModelAnnotation(getName="培训类型",column = "traintype")
    private String traintype;

    /**
    * 订单状态 1待付款2取消订单3权限配置中4完成
    */
    @ModelAnnotation(getName="订单状态",column = "orderstate")
    private String orderstate;

    /**
     * 订单类型 1单独购买 2 免费赠送（保险送）
     */
    @ModelAnnotation(getName="订单类型",column = "ordertype")
    private String ordertype;

    /**
     * 订单日期类型 1、月 2、季 3、半年4、年
     */
    @ModelAnnotation(getName="订单日期类型",column = "dateType")
    private String dateType;
    
    public Long getUserid() {
        return userid;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public String getOrdernumber() {
        return ordernumber;
    }

    public void setOrdernumber(String ordernumber) {
        this.ordernumber = ordernumber;
    }

    public String getPaystate() {
        return paystate;
    }

    public void setPaystate(String paystate) {
        this.paystate = paystate;
    }

    public Date getEffectivestarttime() {
        return effectivestarttime;
    }

    public void setEffectivestarttime(Date effectivestarttime) {
        this.effectivestarttime = effectivestarttime;
    }

    public Date getEffectiveendtime() {
        return effectiveendtime;
    }

    public void setEffectiveendtime(Date effectiveendtime) {
        this.effectiveendtime = effectiveendtime;
    }

    public String getInvoicename() {
        return invoicename;
    }

    public void setInvoicename(String invoicename) {
        this.invoicename = invoicename;
    }

    public Long getInvoiceid() {
        return invoiceid;
    }

    public void setInvoiceid(Long invoiceid) {
        this.invoiceid = invoiceid;
    }

    public String getSendaddress() {
        return sendaddress;
    }

    public void setSendaddress(String sendaddress) {
        this.sendaddress = sendaddress;
    }

    public String getSignatory() {
        return signatory;
    }

    public void setSignatory(String signatory) {
        this.signatory = signatory;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getGoodsname() {
        return goodsname;
    }

    public void setGoodsname(String goodsname) {
        this.goodsname = goodsname;
    }

    public String getUnitprice() {
        return unitprice;
    }

    public void setUnitprice(String unitprice) {
        this.unitprice = unitprice;
    }

    public Integer getCountnumber() {
        return countnumber;
    }

    public void setCountnumber(Integer countnumber) {
        this.countnumber = countnumber;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Long getTrainorgid() {
        return trainorgid;
    }

    public void setTrainorgid(Long trainorgid) {
        this.trainorgid = trainorgid;
    }

    public String getCompanyname() {
        return companyname;
    }

    public void setCompanyname(String companyname) {
        this.companyname = companyname;
    }

    public String getTraintype() {
        return traintype;
    }

    public void setTraintype(String traintype) {
        this.traintype = traintype;
    }

    public String getOrderstate() {
        return orderstate;
    }

    public void setOrderstate(String orderstate) {
        this.orderstate = orderstate;
    }

	public String getOrdertype() {
		return ordertype;
	}

	public void setOrdertype(String ordertype) {
		this.ordertype = ordertype;
	}

	public String getRandomOrderNo() {
		return randomOrderNo;
	}

	public void setRandomOrderNo(String randomOrderNo) {
		this.randomOrderNo = randomOrderNo;
	}

	public String getDateType() {
		return dateType;
	}
	public void setDateType(String dateType) {
		this.dateType = dateType;
	}
}