package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import lombok.Data;

import java.util.Date;

/**
 * 离京登记实体类
 * enrolment_leave_beijing
 *
 * @author zhangyutong
 */
@Data
public class EnrolmentLeaveBeijing extends BaseModel {

    /**
     * 监管机构id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long orgId;

    /**
     * 公司名称
     */
    @ModelAnnotation(getName = "所属企业", isExport = true, column = "com_name", sign = SignType.LIKE)
    private String comName;

    /**
     * 公司id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /**
     * 填写人
     */
    private String fillerName;

    /**
     * 填写人电话
     */
    private String fillerPhone;

    /**
     * 离京的保安员姓名
     */
    @ModelAnnotation(getName = "保安员姓名", isExport = true, column = "leave_person_name", sign = SignType.LIKE)
    private String leavePersonName;

    /**
     * 离京的保安员身份证号
     */
    @ModelAnnotation(getName = "保安员身份证号", isExport = true, column = "leave_person_id_number", sign = SignType.LIKE)
    private String leavePersonIdNumber;

    /**
     * 离京的保安员手机号码
     */
    @ModelAnnotation(getName = "手机号", isExport = true, column = "leave_person_phone", sign = SignType.LIKE)
    private String leavePersonPhone;

    /**
     * 离京时间
     */
    @ModelAnnotation(getName = "离京时间", isExport = true, column = "leave_time")
    private Date leaveTime;

    /**
     * 目的地区域code
     */
    private String area;

    /**
     * 目的地区域名称
     */
    @ModelAnnotation(getName = "目的地区县", isExport = true, column = "areaName")
    private String areaName;
    /**
     * 离开准备去往的目的地
     */
    @ModelAnnotation(getName = "目的地详细地址", isExport = true, column = "leave_destination")
    private String leaveDestination;

    /**
     * 预计归期
     */
    @ModelAnnotation(getName = "预计归期", isExport = true, column = "leave_return_time")
    private Date leaveReturnTime;

    /**
     * 交通方式
     */
    @ModelAnnotation(getName = "交通方式", isExport = true, column = "leave_transportation")
    private String leaveTransportation;

    /**
     * 到达日期
     */
    @ModelAnnotation(getName = "到达日期", isExport = true, column = "arrival_time")
    private Date arrivalTime;



    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}