package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;

import java.util.Map;

public class EqualAndNullExportWhereStrategy implements ExportWhereStrategy {
    @Override
    public String spliceWhereStr(SignType signType, Map<String,String> columnMap, Map<Object, Object> searchParams, Object key) {
        StringBuilder columnStr = new StringBuilder();
        columnStr.append(" and ifnull(")
                .append(columnMap.get(key))
                .append(",'")
                .append(searchParams.get(key))
                .append("') ")
                .append(signType.getOperator())
                .append(" '")
                .append(searchParams.get(key))
                .append("' ");
        return columnStr.toString();
    }
}
