package com.bcxin.ars.dto.sys;

import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/03/17 0017 10:09
 */
@Data
public class MenuDto extends BaseModel {

    /**
     * 菜单链接
     *
     */
    private String location;
    /**
     * 节点文本
     *
     */
    private String name;
    /**
     * 父节点ID
     *
     */
    private Long parentId;
    /**
     * 同级菜单中排序序号
     *
     */
    private Integer seq;
    /**
     * 结点类型：0菜单1按钮
     *
     */
    private String menuType = "0";
    /**
     * 主界面图标class
     *
     */
    private String iconClass;
    /**
     * 权限标识
     *
     */
    private String permission;
    /**
     * 父节点的id列表，如"100001/100020/100022/"，分别列出从根开始的编码
     *
     */
    private String parentIds;

    /**
     * 资源描述
     */
    private String resouceDesc;

    private String state = "closed";

    private List<MenuDto> children;

}
