package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.model.task.ComTempTask;
import lombok.Data;
import java.util.Date;
import com.bcxin.ars.model.BaseModel;


/**
 * 临保任务查询dto
 *
 * @author lin
 * @date 2021-02-01
 */
@Data
public class ComTempTaskPageSearchDto extends SearchDto<ComTempTaskDto> {
    private static final long serialVersionUID = 1L;

    
    /**
     * 临保任务ID
     */
    private Long comTempTaskId;

    /**
     * 创建人ID
     */
    private Long userId;
    

    /**
     * 任务名称
     */
    private String taskName;
    

    /**
     * 驻勤点类型
     */
    private String taskStationType;
    

    /**
     * 服务对象类型
     */
    private String serviceObjectType;

    /**
     * 任务状态
     */
    private String taskStatus;

    /**
     * 企业合同ID
     */
    private Long comContractId;
    
    /**
     * 监管机构id
     */
    private Long orgId;
    
    /**
     * 监管机构名称
     */
    private String orgName;
    
    /**
     * 监管机构区域code
     */
    private String areaCode;
    
    /**
     * 企业ID
     */
    private Long comId;

    /**
     * 公司名称
     */
    private String comName;

    /**
     * 保安人员数
     */
    private int perNum;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

}
