package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * sb_personcertificate 保安员证考试报名导出
 * yyx 20200612
 */
@Data
public class VPersonCertExportDTO {
    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * 姓名
     */
    @ModelAnnotation(getName = "姓名",isExport = true,column = "name",defaultColumn=true,sign = SignType.LIKE)
    private String name;
    /**
     * 身份证号码
     */
    @ModelAnnotation(getName = "身份证号码",isExport = true,column = "cardNumber",defaultColumn=true,sign = SignType.LIKE)
    private String cardNumber;

    /**
     * 联系电话
     */
    @ModelAnnotation(getName="手机号",column = "phone",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String phone;
    /**
     * 报名公司名称
     */
    @ModelAnnotation(getName="报名公司名称",column = "scName",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String scName;


    /**
     * 培训机构名称
     */
    @ModelAnnotation(getName="所属培训机构",column = "trainOrgName",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String trainOrgName;
    /**
     * 所属公安机构
     */
    @ModelAnnotation(getName="机构id",column = "orgId")
    private Long orgId;
    @ModelAnnotation(getName="机构区域",column = "areaCode",sign = SignType.LIKE_AREACODE)
    private String orgAreaCode;
    /**
     * 报名日期
     */
    @ModelAnnotation(getName="报名日期",column = "createTime",isExport = true,defaultColumn=true)
    private Date createTime;
    /**
     * 报名开始日期时间
     */
    @ModelAnnotation(getName="报名开始日期时间",column = "createTime",sign = SignType.DATE_GREATER_EQUAL)
    private Date startTime;
    /**
     * 报名结束日期时间
     */
    @ModelAnnotation(getName="报名结束日期时间",column = "createTime",sign = SignType.DATE_LESS_EQUAL)
    private Date endTime;



    /** 考试日期 */
    @ModelAnnotation(getName="考试日期",column = "examTime",isExport = true,DATE_FORMAT = "%Y-%m-%d")
    private String examTime;


    /** 考试开始时间 */
    @ModelAnnotation(getName="考试开始时间",column = "examTime",isExport = true,sign =SignType.DATE_GREATER_EQUAL )
    private String examStart;

    /** 考试结束时间 */
    @ModelAnnotation(getName="考试结束时间",column = "examTime",isExport = true,sign =SignType.DATE_LESS_EQUAL )
    private String examEnd;

    /**
     * 审批状态
     */
    @ModelAnnotation(getName="审批状态",column = "approvalState",isExport = true,defaultColumn=true,needTranslate = true,dictName ="approvalState")
    private String approvalState;
    /**
     * 审查状态 001未审查 003 审查通过 004审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "censorStatus",isExport = true,defaultColumn=true,needTranslate = true,dictName = "cerCensorStatus")
    private String censorStatus;
    /**
     * 缴费状态 1已缴费 0 未缴费
     */
    @ModelAnnotation(getName="缴费状态",column = "feeState",isExport = true,defaultColumn=true,needTranslate = true,dictName = "feeState")
    private String feeState;
    /**
     * 考试状态 1通过0不通过
     */
    @ModelAnnotation(getName="考试状态",column = "testState",isExport = true,defaultColumn=true,needTranslate = true,dictName = "testState")
    private String testState;
    /**
     * 材料核对状态
     */
    @ModelAnnotation(getName="材料核对状态",column = "checkState",isExport = true,defaultColumn=true,needTranslate = true,dictName = "checkState")
    private String checkState;

    /**
     * 考试安排状态：0未安排，1已安排，2已取消,3 已修改
     */
    @ModelAnnotation(getName="考试安排状态",column = "examState",isExport = true,defaultColumn=true,needTranslate = true,dictName = "examState")
    private String examState;


    /**
     * 笔试成绩
     */
    @ModelAnnotation(getName="笔试成绩",column = "writtenScore",isExport = true,defaultColumn=true)
    private Integer writtenScore;
    /**
     * 审批时间
     */
    @ModelAnnotation(getName="审批时间",column = "approvaldate",isExport = true)
    private String approvaldate;
    /**
     * 审批人
     */
    @ModelAnnotation(getName="审批人",column = "approvalperson",isExport = true)
    private String approvalperson;
    /**
     * 审批原因
     */
    @ModelAnnotation(getName="审批原因",column = "approvalreason",isExport = true)
    private String approvalreason;
    /***
     * 申领状态
     */
    @ModelAnnotation(getName="申领状态",column = "applyforstate",isExport = true)
    private String applyforstate;
    /**
     * 性别
     */
    @ModelAnnotation(getName = "性别",isExport = true,column = "sex",needTranslate = true,dictName = "sex")
    private String sex;

    /**
     * 出生年月
     */
    @ModelAnnotation(getName = "出生年月",isExport = true,column = "Brith")
    private String brith;

    /**
     * 民族
     */
    @ModelAnnotation(getName = "民族",isExport = true,column = "nation",specialTranslateType = "1",dictName = "nation")
    private String nation;

    /**
     *政治面貌
     */
    @ModelAnnotation(getName="政治面貌",column = "Politics",isExport = true,needTranslate = true,dictName = "politics")
    private String politics;
    /**
     * 户籍地址
     */
    @ModelAnnotation(getName="户籍地址",column = "address",isExport = true)
    private String address;
    /**
     * 文化程度
     */
    @ModelAnnotation(getName="文化程度",column = "Culture",isExport = true,needTranslate = true,dictName = "edu")
    private String culture;

    /**
     * 邮编
     */
    @ModelAnnotation(getName="邮编",column = "Zipcode",isExport = true)
    private String zipcode;

    /**
     * 曾用名
     */
    @ModelAnnotation(getName="曾用名",column = "beforeName",isExport = true)
    private String beforeName;

    /**
     * 社会保障卡
     */
    @ModelAnnotation(getName="社会保障卡",column = "guaranteecar",isExport = true)
    private String guaranteecar;

    /**
     * 家庭电话
     */
    @ModelAnnotation(getName="家庭电话",column = "familyPhone",isExport = true)
    private String familyPhone;
    /**
     * 兵役情况
     */
    @ModelAnnotation(getName="兵役情况",column = "militaryService",isExport = true,needTranslate = true,dictName = "militaryService")
    private String militaryService;
    /**
     * 指纹卡号
     */
    @ModelAnnotation(getName="指纹卡号",column = "fingerprint",isExport = true)
    private String fingerprint;

    /**
     * 宗教信仰
     */
    @ModelAnnotation(getName="宗教信仰",column = "religion",isExport = true)
    private String religion;

    /***
     * 国籍
     */
    @ModelAnnotation(getName="国籍",column = "nationality",isExport = true)
    private String nationality;

    /**
     * 籍贯
     */
    @ModelAnnotation(getName="籍贯",column = "birthPlace",isExport = true)
    private String birthPlace;

    /**
     * 身高
     */
    @ModelAnnotation(getName="身高",column = "hight",isExport = true)
    private String hight;
    /**
     * 血型
     */
    @ModelAnnotation(getName="血型",column = "booldType",isExport = true)
    private String booldType;

    /**
     * 健康状况
     */
    @ModelAnnotation(getName="健康状况",column = "healthStatus",isExport = true)
    private String healthStatus;
    /**
     * 现住地址
     */
    @ModelAnnotation(getName="现住地址",column = "nowAddress",isExport = true)
    private String nowAddress;
    /**
     * 备注
     */
    @ModelAnnotation(getName="备注",column = "baseRemack",isExport = true)
    private String baseRemack;

    /**
     * 所在地省市县（区）
     **/
    @ModelAnnotation(getName="所在地省市县（区）",column = "szss",isExport = true)
    private String szss;
    /**
     * 所在地县（区）代码
     **/
    @ModelAnnotation(getName="所在地县（区）代码",column = "areaCode",isExport = true,sign = SignType.LIKE_AREACODE)
    private String areaCode;

    /**
     * 无违法犯罪记录证明
     **/
    @ModelAnnotation(getName="无违法犯罪记录证明",column = "nocrime_photo",isExport = true)
    private String nocrimePhoto;

    /**
     * 实操成绩
     */
    @ModelAnnotation(getName="实操成绩",column = "operate_score",isExport = true)
    private Integer operateScore;

    /**
     * 总成绩
     */
    @ModelAnnotation(getName="总成绩",column = "sum_score",isExport = true)
    private Double sumScore;

    /**
     * 指纹卡号状态1已录0未录
     */
    @ModelAnnotation(getName="指纹卡号状态",column = "fingercard_state",isExport = true,needTranslate = true,dictName = "fingercardState")
    private String fingercardState;


    /** 考点名称 */
    @ModelAnnotation(getName="考点名称",column = "exam_address",isExport = true)
    private String examAddress;



    /** 体能测试地址 */
    @ModelAnnotation(getName="体能测试地址",column = "stamina_address",isExport = true)
    private String staminaAddress;

    /** 体能测试开始时间 */
    @ModelAnnotation(getName="体能测试开始时间",column = "stamina_startDate",isExport = true)
    private String staminaStartDate;

    /** 体能测试结束时间 */
    @ModelAnnotation(getName="体能测试结束时间",column = "stamina_endDate",isExport = true)
    private String staminaEndDate;
    /***
     * 报名确认（001未确认002已确认）
     */
    @ModelAnnotation(getName="报名确认",column = "signConfirm",isExport = true,needTranslate = true,dictName = "signConfirm")
    private String signConfirm;
    /***
     * 缴费确认状态
     */
    @ModelAnnotation(getName="缴费确认状态",column = "payConfirm",isExport = true)
    private String payConfirm;

    /**
     * 补考次数
     */
    @ModelAnnotation(getName="补考次数",column = "makeUpCount",isExport = true,specialTranslateType = "4")
    private Integer makeUpCount;
    /**
     * 是否补考
     */
    @ModelAnnotation(getName="是否补考",column = "isMakeUp",isExport = true,needTranslate = true,dictName ="isMakeUp")
    private String isMakeUp;

    /**
     * 是否自然人
     */
    @ModelAnnotation(getName="是否自然人",column = "naturalPer", defaultColumn =true ,isExport = true,needTranslate = true,dictName ="BOOLEAN",sign = SignType.EQUAL_NULL_ZERO)
    private String naturalPer;

    /**
     * 流程状态  1 流程结束  其他 流程未结束
     */
    @ModelAnnotation(getName="流程状态",column = "proState",isExport = true,needTranslate = true,dictName ="proState")
    private String proState;

    /**
     * 补考状态  003补考通过 004补考未通过
     */
    @ModelAnnotation(getName = "补考状态", column = "makeUpstate", isExport = true, needTranslate = true, dictName = "makeUpstate")
    private String makeUpstate;

    @ModelAnnotation(getName = "缴费公司", column = "payComName", isExport = true)
    private String payComName;

    /**
     * 理论学习进度,
     * 0-99 未完成; 100 完成
     */
    @ModelAnnotation(getName = "理论学习进度", column = "learnRate", isExport = true, sign = SignType.LEARN_RATE_SIGN)
    private String learnRate;

}
