package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

@Data
public class CompanyPunishExportDto {
    /** 机构类型 */
    @ModelAnnotation(getName="机构类型",column = "institutionType",isExport = true,needTranslate = true,dictName ="institutionType")
    private String institutionType;

    /** 公司名称 */
    @ModelAnnotation(getName = "公司名称",column = "company_name",isExport = true,sign = SignType.LIKE)
    private String companyName;

    /** 案件编号 */
    @ModelAnnotation(getName = "案件编号",column = "case_no",isExport = true)
    private String caseNo;

    /** 处罚时间 */
    @ModelAnnotation(getName="处罚时间",column = "punish_date",isExport = true)
    private String punishDate;

    /** 处罚查询开始时间 */
    @ModelAnnotation(getName="检查时间开始时间",column = "punish_date",sign = SignType.DATE_GREATER_EQUAL)
    private String startDate;

    /** 处罚查询结束时间 */
    @ModelAnnotation(getName="检查时间开始时间",column = "punish_date",sign = SignType.DATE_LESS_EQUAL)
    private String endDate;

    /** 作出处罚单位 */
    @ModelAnnotation(getName = "作出处罚单位",column = "org_name",isExport = true,sign = SignType.LIKE)
    private String orgName;
    /** 作出处罚单位id */
    @ModelAnnotation(getName = "作出处罚单位id",column = "org_id",sign = SignType.EQUAL_NULL_ZERO)
    private String orgId;
    @ModelAnnotation(getName = "公安areaCode",column = "orgAreaCode",sign = SignType.LIKE_AREACODE)
    private String orgAreaCode;

    /** 作出处罚决定的其他单位 */
    @ModelAnnotation(getName="作出处罚决定的其他单位",column = "other_org",isExport = true)
    private String otherOrg;

    /** 处罚原因 */
    @ModelAnnotation(getName="处罚原因",column = "reason",isExport = true)
    private String reason;

    /** 处罚内容 */
    @ModelAnnotation(getName="处罚内容",column = "content",isExport = true)
    private String content;

    /** 数据来源 */
    @ModelAnnotation(getName="数据来源",column = "dataSource",isExport = true,needTranslate = true,dictName ="dataSource")
    private String dataSource;

    /** 被检查人签名 */
    @ModelAnnotation(getName="被检查人签名",column = "signImgPath",isExport = true)
    private String signImgPath;
}
