package com.abcxin.smart.validator.annotation;

import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.enums.ImportType;

import java.lang.annotation.*;

/**
 * 外导内
 * @ClassName：com.abcxin.smart.validator.annotation
 * @author：linqinglin
 * @date：2019/04/03 9:32
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface DataSyncAnnotation {

    /**
     * 排序
     * @return
     */
    int getSeq() default 1000;

    /**
     * 实体类
     * @return
     */
    Class<?> getClazz();

    /**
     * 保存方法名
     */
    String getMethodName() default "saveOrUpdateForDS";

    /**
     * 搜索方法名
     */
    String getSearchMethodName() default "searchForDataSynchronization";

    /**
     * 导入的类型 批量导入还是单个
     * @return
     */
    ImportType getImportType() default ImportType.FOREACH;

    /**
     * 同步或者异步执行
     * 默认异步
     * @return
     */
    SyncType getDataSyncType() default  SyncType.ASYNC;
}
