/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.generator;

import com.bcxin.risk.hibernateplus.generator.AbstractGenerator;
import com.bcxin.risk.hibernateplus.generator.config.ConstVal;
import com.bcxin.risk.hibernateplus.generator.config.TemplateConfig;
import com.bcxin.risk.hibernateplus.generator.config.builder.ConfigBuilder;
import com.bcxin.risk.hibernateplus.generator.config.po.TableInfo;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jboss.logging.Logger;

public class AutoGenerator
extends AbstractGenerator {
    private static final Logger logger = Logger.getLogger(AutoGenerator.class);
    private VelocityEngine engine;

    public void execute() {
        logger.debug((Object)"==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        this.initConfig();
        this.mkdirs(this.config.getPathInfo());
        Map<String, VelocityContext> ctxData = this.analyzeData(this.config);
        for (Map.Entry<String, VelocityContext> ctx : ctxData.entrySet()) {
            this.batchOutput(ctx.getKey(), ctx.getValue());
        }
        if (this.config.getGlobalConfig().isOpen()) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + this.config.getGlobalConfig().getOutputDir());
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + this.config.getGlobalConfig().getOutputDir());
                    } else {
                        logger.debug((Object)("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + this.config.getGlobalConfig().getOutputDir()));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)"==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
    }

    private Map<String, VelocityContext> analyzeData(ConfigBuilder config) {
        List<TableInfo> tableList = config.getTableInfoList();
        Map<String, String> packageInfo = config.getPackageInfo();
        HashMap<String, VelocityContext> ctxData = new HashMap<String, VelocityContext>();
        String superModelClass = this.getSuperClassName(config.getSuperModelClass());
        String superDaoClass = this.getSuperClassName(config.getSuperDaoClass());
        String superDaoImplClass = this.getSuperClassName(config.getSuperDaoImplClass());
        String superServiceClass = this.getSuperClassName(config.getSuperServiceClass());
        String superServiceImplClass = this.getSuperClassName(config.getSuperServiceImplClass());
        String superControllerClass = this.getSuperClassName(config.getSuperControllerClass());
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (TableInfo tableInfo : tableList) {
            VelocityContext ctx = new VelocityContext();
            ctx.put("package", packageInfo);
            ctx.put("author", (Object)config.getGlobalConfig().getAuthor());
            ctx.put("date", (Object)date);
            ctx.put("table", (Object)tableInfo);
            ctx.put("po", (Object)tableInfo.getPoName());
            ctx.put("vo", (Object)tableInfo.getVoName());
            ctx.put("modelColumnConstant", (Object)config.getStrategyConfig().isModelColumnConstant());
            ctx.put("modelBuliderModel", (Object)config.getStrategyConfig().isModelBuliderModel());
            ctx.put("tabeAnnotation", (Object)(!tableInfo.getPoName().toLowerCase().equals(tableInfo.getName().toLowerCase()) ? 1 : 0));
            ctx.put("superModelClassPackage", (Object)config.getSuperModelClass());
            ctx.put("superModelClass", (Object)superModelClass);
            ctx.put("superDaoClassPackage", (Object)config.getSuperDaoClass());
            ctx.put("superDaoClass", (Object)superDaoClass);
            ctx.put("superDaoImplClassPackage", (Object)config.getSuperDaoImplClass());
            ctx.put("superDaoImplClass", (Object)superDaoImplClass);
            ctx.put("superServiceClassPackage", (Object)config.getSuperServiceClass());
            ctx.put("superServiceClass", (Object)superServiceClass);
            ctx.put("superServiceImplClassPackage", (Object)config.getSuperServiceImplClass());
            ctx.put("superServiceImplClass", (Object)superServiceImplClass);
            ctx.put("superControllerClassPackage", (Object)config.getSuperControllerClass());
            ctx.put("superControllerClass", (Object)superControllerClass);
            ctxData.put(tableInfo.getPoName(), ctx);
        }
        return ctxData;
    }

    private String getSuperClassName(String classPath) {
        if (StringUtils.isBlank(classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    private void mkdirs(Map<String, String> pathInfo) {
        for (Map.Entry<String, String> entry : pathInfo.entrySet()) {
            boolean result;
            File dir = new File(entry.getValue());
            if (dir.exists() || !(result = dir.mkdirs())) continue;
            logger.debug((Object)("\u521b\u5efa\u76ee\u5f55\uff1a [" + entry.getValue() + "]"));
        }
    }

    private void batchOutput(String poName, VelocityContext context) {
        try {
            TableInfo tableInfo = (TableInfo)context.get("table");
            Map<String, String> pathInfo = this.config.getPathInfo();
            String poFile = String.format(pathInfo.get("po_path") + ConstVal.MODEL_NAME, poName);
            String voFile = String.format(pathInfo.get("vo_path") + ConstVal.MODEL_NAME, tableInfo.getVoName());
            String daoFile = String.format(pathInfo.get("dao_path") + File.separator + tableInfo.getDaoName() + ".java", poName);
            String daoimplFile = String.format(pathInfo.get("daoimpl_path") + File.separator + tableInfo.getDaoImplName() + ".java", poName);
            String serviceFile = String.format(pathInfo.get("serivce_path") + File.separator + tableInfo.getServiceName() + ".java", poName);
            String serviceimplFile = String.format(pathInfo.get("serviceimpl_path") + File.separator + tableInfo.getServiceImplName() + ".java", poName);
            String controllerFile = String.format(pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + ".java", poName);
            TemplateConfig template = this.config.getTemplate();
            if (this.isCreate(poFile)) {
                this.vmToFile(context, template.getPo(), poFile);
            }
            if (this.isCreate(voFile)) {
                this.vmToFile(context, template.getVo(), voFile);
            }
            if (this.isCreate(daoFile)) {
                this.vmToFile(context, template.getDao(), daoFile);
            }
            if (this.isCreate(daoimplFile)) {
                this.vmToFile(context, template.getDaoImpl(), daoimplFile);
            }
            if (this.isCreate(serviceFile)) {
                this.vmToFile(context, template.getService(), serviceFile);
            }
            if (this.isCreate(serviceimplFile)) {
                this.vmToFile(context, template.getServiceImpl(), serviceimplFile);
            }
            if (this.isCreate(controllerFile)) {
                this.vmToFile(context, template.getController(), controllerFile);
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
    }

    private void vmToFile(VelocityContext context, String templatePath, String outputFile) throws IOException {
        VelocityEngine velocity = this.getVelocityEngine();
        Template template = velocity.getTemplate(templatePath, ConstVal.UTF8);
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8));
        template.merge((Context)context, (Writer)writer);
        writer.close();
        logger.debug((Object)("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile));
    }

    private VelocityEngine getVelocityEngine() {
        if (this.engine == null) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("file.resource.loader.path", "");
            p.setProperty("ISO-8859-1", ConstVal.UTF8);
            p.setProperty("input.encoding", ConstVal.UTF8);
            p.setProperty("output.encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.engine = new VelocityEngine(p);
        }
        return this.engine;
    }

    private boolean isCreate(String filePath) {
        File file = new File(filePath);
        return !file.exists() || this.config.getGlobalConfig().isFileOverride();
    }
}

