/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;

    public static File zip(String srcPath) throws UtilException {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws UtilException {
        return ZipUtil.zip(FileUtil.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws UtilException {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws UtilException {
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws UtilException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws UtilException {
        return ZipUtil.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws UtilException {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws UtilException {
        return ZipUtil.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws UtilException {
        ZipUtil.validateFiles(zipFile, srcFiles);
        ZipOutputStream out = null;
        try {
            out = ZipUtil.getZipOutputStream(zipFile, charset);
            for (File srcFile : srcFiles) {
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getParent();
                }
                ZipUtil.zip(srcFile, srcRootDir, out);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(out);
        }
        return zipFile;
    }

    public static File zip(File zipFile, String path, String data) throws UtilException {
        return ZipUtil.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws UtilException {
        return ZipUtil.zip(zipFile, path, IoUtil.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws UtilException {
        return ZipUtil.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws UtilException {
        return ZipUtil.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws UtilException {
        return ZipUtil.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) throws UtilException {
        if (ArrayUtil.isEmpty(paths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream out = null;
        try {
            out = ZipUtil.getZipOutputStream(zipFile, charset);
            for (int i = 0; i < paths.length; ++i) {
                ZipUtil.zip(ins[i], paths[i], out);
            }
        }
        finally {
            IoUtil.close(out);
        }
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws UtilException {
        return ZipUtil.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath));
    }

    public static File unzip(File zipFile) throws UtilException {
        return ZipUtil.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) throws UtilException {
        return ZipUtil.unzip(zipFile, FileUtil.file(zipFile.getParentFile(), FileUtil.mainName(zipFile)), charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws UtilException {
        return ZipUtil.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws UtilException {
        return ZipUtil.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) throws UtilException {
        charset = null == charset ? DEFAULT_CHARSET : charset;
        ZipFile zipFileObj = null;
        try {
            zipFileObj = new ZipFile(zipFile, charset);
            Enumeration<? extends ZipEntry> em = zipFileObj.entries();
            ZipEntry zipEntry = null;
            File outItemFile = null;
            while (em.hasMoreElements()) {
                zipEntry = em.nextElement();
                outItemFile = new File(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtil.touch(outItemFile);
                ZipUtil.copy(zipFileObj, zipEntry, outItemFile);
            }
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(zipFileObj);
                throw throwable;
            }
        }
        IoUtil.close(zipFileObj);
        return outFile;
    }

    public static byte[] gzip(String content, String charset) throws UtilException {
        return ZipUtil.gzip(StrUtil.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] val) throws UtilException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            val = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gos);
                throw throwable;
            }
        }
        IoUtil.close(gos);
        return val;
    }

    public static byte[] gzip(File file) throws UtilException {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            BufferedInputStream in = FileUtil.getInputStream(file);
            IoUtil.copy(in, gos);
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gos);
                throw throwable;
            }
        }
        IoUtil.close(gos);
        return byArray;
    }

    public static String unGzip(byte[] buf, String charset) throws UtilException {
        return StrUtil.str(ZipUtil.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws UtilException {
        GZIPInputStream gzi = null;
        ByteArrayOutputStream bos = null;
        try {
            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
            bos = new ByteArrayOutputStream(buf.length);
            IoUtil.copy(gzi, bos);
            buf = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gzi);
                throw throwable;
            }
        }
        IoUtil.close(gzi);
        return buf;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipUtil.getZipOutputStream(FileUtil.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        charset = null == charset ? DEFAULT_CHARSET : charset;
        return new ZipOutputStream(out, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File file, String srcRootDir, ZipOutputStream out) throws UtilException {
        if (file == null) {
            return;
        }
        String subPath = FileUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            if (StrUtil.isNotEmpty(subPath)) {
                ZipUtil.zipDir(subPath, out);
            }
            for (File childFile : file.listFiles()) {
                ZipUtil.zip(childFile, srcRootDir, out);
            }
        } else {
            BufferedInputStream in = null;
            try {
                in = FileUtil.getInputStream(file);
                ZipUtil.zip(in, subPath, out);
            }
            finally {
                IoUtil.close(in);
            }
        }
    }

    private static void zip(InputStream in, String path, ZipOutputStream out) throws UtilException {
        if (null == in) {
            return;
        }
        try {
            out.putNextEntry(new ZipEntry(path));
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            ZipUtil.closeEntry(out);
        }
    }

    private static void zipDir(String path, ZipOutputStream out) throws UtilException {
        path = StrUtil.addSuffixIfNot(path, "/");
        try {
            out.putNextEntry(new ZipEntry(path));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            ZipUtil.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        for (File srcFile : srcFiles) {
            if (!srcFile.exists()) {
                throw new UtilException(StrUtil.format((CharSequence)"File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                if (srcFile.isDirectory() && zipFile.getParent().contains(srcFile.getCanonicalPath())) {
                    throw new UtilException("[zipPath] must not be the child directory of [srcPath]!");
                }
                if (zipFile.exists()) continue;
                FileUtil.touch(zipFile);
            }
            catch (IOException e) {
                throw new UtilException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileUtil.getOutputStream(outItemFile);
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(out);
        IoUtil.close(in);
    }
}

