/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect.log4j;

import com.xiaoleilu.hutool.log.AbstractLocationAwareLog;
import com.xiaoleilu.hutool.log.level.Level;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4jLog.class.getName();
    private final transient Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(Logger.getLogger(clazz));
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.TRACE, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.DEBUG, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.INFO, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.WARN, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.ERROR, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        org.apache.log4j.Level log4jLevel;
        switch (level) {
            case TRACE: {
                log4jLevel = org.apache.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                log4jLevel = org.apache.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                log4jLevel = org.apache.log4j.Level.INFO;
                break;
            }
            case WARN: {
                log4jLevel = org.apache.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                log4jLevel = org.apache.log4j.Level.ERROR;
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logger.log(fqcn, (Priority)log4jLevel, (Object)StrUtil.format((CharSequence)format, arguments), t);
    }
}

