/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.geo;

import com.xiaoleilu.hutool.geo.Location;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -7145192134410261076L;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;

    public BoundingBox(Location p1, Location p2) {
        this(p1.getLatitude(), p2.getLatitude(), p1.getLongitude(), p2.getLongitude());
    }

    public BoundingBox(double latitude1, double latitude2, double longitude1, double longgitude2) {
        this.minLat = Math.min(latitude1, latitude2);
        this.maxLat = Math.max(latitude1, latitude2);
        this.minLon = Math.min(longgitude2, longgitude2);
        this.maxLon = Math.max(longitude1, longgitude2);
    }

    public BoundingBox(BoundingBox that) {
        this(that.minLat, that.maxLat, that.minLon, that.maxLon);
    }

    public boolean contains(Location point) {
        double latitude = point.getLatitude();
        double longitude = point.getLongitude();
        return latitude >= this.minLat && longitude >= this.minLon && latitude <= this.maxLat && longitude <= this.maxLon;
    }

    public boolean intersects(BoundingBox other) {
        return false == (other.minLon > this.maxLon || other.maxLon < this.minLon || other.minLat > this.maxLat || other.maxLat < this.minLat);
    }

    public Location getCenterPoint() {
        double centerLatitude = (this.minLat + this.maxLat) / 2.0;
        double centerLongitude = (this.minLon + this.maxLon) / 2.0;
        return new Location(centerLatitude, centerLongitude);
    }

    public void expandToInclude(BoundingBox other) {
        if (other.minLon < this.minLon) {
            this.minLon = other.minLon;
        }
        if (other.maxLon > this.maxLon) {
            this.maxLon = other.maxLon;
        }
        if (other.minLat < this.minLat) {
            this.minLat = other.minLat;
        }
        if (other.maxLat > this.maxLat) {
            this.maxLat = other.maxLat;
        }
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public Location getUpperLeft() {
        return new Location(this.maxLat, this.minLon);
    }

    public Location getLowerRight() {
        return new Location(this.minLat, this.maxLon);
    }

    public double getLatitudeSize() {
        return this.maxLat - this.minLat;
    }

    public double getLongitudeSize() {
        return this.maxLon - this.minLon;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox other = (BoundingBox)obj;
            return Double.valueOf(this.minLat).equals(other.minLat) && Double.valueOf(this.minLon).equals(other.minLon) && Double.valueOf(this.maxLat).equals(other.maxLat) && Double.valueOf(this.maxLon).equals(other.maxLon);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + BoundingBox.hashCode(this.minLat);
        result = 37 * result + BoundingBox.hashCode(this.maxLat);
        result = 37 * result + BoundingBox.hashCode(this.minLon);
        result = 37 * result + BoundingBox.hashCode(this.maxLon);
        return result;
    }

    private static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public String toString() {
        return this.getUpperLeft() + " -> " + this.getLowerRight();
    }
}

