/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.extra.mail;

import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Serializable;
import java.util.Properties;

public class MailAccount
implements Serializable {
    private static final long serialVersionUID = -6937313421815719204L;
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String STARTTTL_ENABLE = "mail.smtp.starttls.enable";
    private static final String SOCKEY_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKEY_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String SOCKEY_FACTORY_PORT = "smtp.socketFactory.port";
    public static final String MAIL_SETTING_PATH = "config/mailAccount.setting";
    private String host;
    private Integer port;
    private Boolean auth = true;
    private String user;
    private String pass;
    private String from;
    private boolean startttlsEnable = false;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;

    public MailAccount() {
    }

    public MailAccount(String settingPath) {
        this(new Setting(settingPath));
    }

    public MailAccount(Setting setting) {
        setting.toBean(this);
    }

    public String getHost() {
        return this.host;
    }

    public MailAccount setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public MailAccount setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isAuth() {
        return this.auth;
    }

    public MailAccount setAuth(boolean isAuth) {
        this.auth = isAuth;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public MailAccount setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public MailAccount setPass(String pass) {
        this.pass = pass;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MailAccount setFrom(String from) {
        this.from = from;
        return this;
    }

    public boolean isStartttlsEnable() {
        return this.startttlsEnable;
    }

    public void setStartttlsEnable(boolean startttlsEnable) {
        this.startttlsEnable = startttlsEnable;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    public void setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public void setSocketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    public void setSocketFactoryPort(int socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
    }

    public Properties getSmtpProps() {
        Properties p = new Properties();
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, this.port);
        p.put(SMTP_AUTH, this.auth);
        if (this.startttlsEnable) {
            p.put(STARTTTL_ENABLE, (Object)this.startttlsEnable);
            p.put(SOCKEY_FACTORY, this.socketFactoryClass);
            p.put(SOCKEY_FACTORY_FALLBACK, (Object)this.socketFactoryFallback);
            p.put(SOCKEY_FACTORY_PORT, (Object)this.socketFactoryPort);
        }
        return p;
    }

    public MailAccount defaultIfEmpty() {
        if (StrUtil.isBlank(this.host)) {
            this.host = StrUtil.format((CharSequence)"smtp.{}", StrUtil.subSuf(this.from, this.from.indexOf(64) + 1));
        }
        if (StrUtil.isBlank(this.user)) {
            this.user = StrUtil.subPre(this.from, this.from.indexOf(64));
        }
        if (null == this.auth) {
            this.auth = false == StrUtil.isBlank(this.pass);
        }
        if (null == this.port) {
            this.port = this.startttlsEnable ? this.socketFactoryPort : 25;
        }
        return this;
    }

    public String toString() {
        return "MailAccount [host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", pass=" + (StrUtil.isEmpty(this.pass) ? "" : "******") + ", from=" + this.from + ", startttlsEnable=" + this.startttlsEnable + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + "]";
    }
}

