/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.sql.Query;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MysqlDialect
extends AnsiSqlDialect {
    public MysqlDialect() {
        this.wrapper = new Wrapper(Character.valueOf('`'));
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        if (query == null || StrUtil.hasBlank(query.getTableNames())) {
            throw new DbRuntimeException("Table name is null !");
        }
        Page page = query.getPage();
        if (null == page) {
            return super.psForFind(conn, query);
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query).orderBy(page.getOrders());
        find.append(" LIMIT ").append(page.getStartPosition()).append(", ").append(page.getNumPerPage());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValueArray());
        return ps;
    }

    @Override
    public DialectName dialectName() {
        return DialectName.MYSQL;
    }
}

