/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.comparator;

import com.xiaoleilu.hutool.comparator.ComparatorException;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;

public class FieldComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 9157326766723846313L;
    private final Field field;

    public FieldComparator(Class<T> beanClass, String fieldName) {
        this.field = ClassUtil.getDeclaredField(beanClass, fieldName);
        if (this.field == null) {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5728\u7c7b" + beanClass + "\u4e2d\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        try {
            v1 = (Comparable)this.field.get(o1);
            v2 = (Comparable)this.field.get(o2);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtil.compare(fieldValue1, fieldValue2);
        if (0 == result && ObjectUtil.notEqual(o1, o2)) {
            return 1;
        }
        return result;
    }
}

