/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.impl;

public class CacheObj<K, V> {
    final K key;
    final V obj;
    long lastAccess;
    long accessCount;
    long ttl;

    CacheObj(K key, V obj, long ttl) {
        this.key = key;
        this.obj = obj;
        this.ttl = ttl;
        this.lastAccess = System.currentTimeMillis();
    }

    boolean isExpired() {
        return this.ttl > 0L && this.lastAccess + this.ttl < System.currentTimeMillis();
    }

    V get() {
        this.lastAccess = System.currentTimeMillis();
        ++this.accessCount;
        return this.obj;
    }

    public String toString() {
        return "CacheObj [key=" + this.key + ", obj=" + this.obj + ", lastAccess=" + this.lastAccess + ", accessCount=" + this.accessCount + ", ttl=" + this.ttl + "]";
    }
}

