package com.bcxin.wechat.weixin.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.wechat.tag.entity.WeiXinTag;
import com.bcxin.wechat.tag.service.WinXinTagService;
import com.bcxin.wechat.weixin.process.WechatProcess;
import com.bcxin.wechat.weixin.service.WeiXinService;
import com.bcxin.wechat.weixin.util.AccessToken;
import com.bcxin.wechat.weixin.util.ConstantWeiXin;
import com.bcxin.wechat.weixin.util.SignUtil;
import com.bcxin.wechat.weixin.util.WeixinUtil;
import com.bcxin.wechat.weixin.util.menu.MenuManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.security.MessageDigest;
import java.util.*;

/**
 * liyongqiang
 * 微信验证模块
 * 2017-8-17
 */
@Controller
@RequestMapping("${weChatPath}/token")
public class WeiXinController {


    @Autowired
    private WeiXinService weiXinService;

    @Autowired
    private WinXinTagService winXinTagService;

    /**
     * 微信验证
     * 收/发送信息
     */
    @RequestMapping("serial")
    @ResponseBody
    public void serial(HttpServletRequest request, HttpServletResponse response) throws IOException {
        // 将请求、响应的编码均设置为UTF-8（防止中文乱码）
        request.setCharacterEncoding("UTF-8"); //微信服务器POST消息时用的是UTF-8编码，在接收时也要用同样的编码，否则中文会乱码；
        response.setCharacterEncoding("UTF-8"); //在响应消息（回复消息给用户）时，也将编码方式设置为UTF-8，原理同上；
        boolean isGet = request.getMethod().toLowerCase().equals("get");
        PrintWriter out = response.getWriter();
        String signature = request.getParameter("signature");        // 随机字符串
        String echostr = request.getParameter("echostr");        // 时间戳
        String timestamp = request.getParameter("timestamp");        // 随机数
        String nonce = request.getParameter("nonce");

        String result = "";
        // 确认请求来至微信
        if (SignUtil.checkSignature(ConstantWeiXin.TOKEN, signature, timestamp, nonce)) {
            {
                /** 读取接收到的xml消息 */
                StringBuffer sb = new StringBuffer();
                InputStream is = request.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                String s = "";
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                }
                String xml = sb.toString();    //次即为接收到微信端发送过来的xml数据

                /** 判断是否是微信接入激活验证，只有首次接入验证时才会收到echostr参数，此时需要把它直接返回 */
                if (echostr != null && echostr.length() > 1) {
                    result = echostr;
                } else {
                    //正常的微信处理流程
                    result = new WechatProcess().processWechatMag(xml,weiXinService,winXinTagService);

                }
                if(request!=null){
                    response.setContentType("application/xml;charset=UTF-8");
                    out.print(result);
                }
            }
        }
    }



    /**
     * 创建菜单
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("menu")
    @ResponseBody
    public String createMenu(HttpServletRequest request, HttpServletResponse response) {
        // 调用接口获取access_token
        AccessToken at = weiXinService.getAccessToken();
        if (null != at) {
            // 调用接口创建菜单
            String result = weiXinService.createMenu(new  MenuManager().getMenu(), at.getToken());

            // 判断菜单创建结果
            if ("success".equals(result)) {
                System.out.println("菜单创建成功！");
                return  "success";
            } else{
                System.out.println("菜单创建失败！");
            }
        }
        return "fail";

    }


    /**
     * 创建微信标签用于分组
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("tag")
    @ResponseBody
    public String createTag(HttpServletRequest request, HttpServletResponse response) {
        // 调用接口获取access_token
        //{"tag":{"id":102,"name":"运营"}}
        AccessToken at = weiXinService.getAccessToken();

        JSONObject  j= new JSONObject();
        JSONObject json2=new JSONObject();
        String  name= request.getParameter("name");
        if(StringUtils.isNotEmpty(name)){
            json2.put("name",name);
        }else{
            return "参数name不能为空";
        }
        j.put("tag", json2);
        if (null != at) {
            String rtn = weiXinService.createTag(j,at.getToken());//本地方法，根据url提交json内容
            if(rtn==null){
                return "返回值有问题，请不要传重复的值";
            }
            try {
                WeiXinTag tag= new WeiXinTag();
                tag.setTagId(rtn);
                tag.setTagName(name);
                winXinTagService.save(tag);

            }catch (Exception ex ){
                 ex.printStackTrace();
            }

            return  rtn;
        }
        return "fail";

    }


    @RequestMapping("joinTag")
    @ResponseBody
    public String joinTag(HttpServletRequest request, HttpServletResponse response) {
        AccessToken at = weiXinService.getAccessToken();
        String url =ConstantWeiXin.JOIN_TAG_USER;
        List<String> tagUserList=new ArrayList<>();
        tagUserList.add("oydrcvrWZW-P_nH8y58VDu3D64hc");
        String rtn = weiXinService.joinUsertoTag( "102",tagUserList,at.getToken());//本地方法，根据url提交json内容
        return rtn;
    }


    /**
     * 根据标签创建特定的二维码场景 （扫码，添加关注）
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("createQrcode")
    @ResponseBody
    public String createQrcode(HttpServletRequest request, HttpServletResponse response) {
        AccessToken at = weiXinService.getAccessToken();
        String  tagId= request.getParameter("tagId");
        if(StringUtils.isNotEmpty(tagId)){

        }else{
            return "参数tagId不能为空";
        }

        String rtn = weiXinService.createQrcode(tagId,at.getToken());//本地方法，根据url提交json内容

        if(rtn==null){
            return "创建场景key失败";
        }else{
            return winXinTagService.updateTagTicket(tagId,rtn);

        }
        //生成时间

    }

}
