package com.bcxin.wechat.util;

import com.alibaba.fastjson.JSON;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 发送http请求
 * @author Administrator
 *
 */
public class HttpUtil {
	private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

	public static String post(String postUrl, Map<String, Object> params) {
		log.info("请求的url："+postUrl+"  请求的参数是："+ JSON.toJSONString(params));
		DataOutputStream outStream = null;
		HttpURLConnection conn =  null;
		try{
			StringBuffer paramStr = new StringBuffer();
			for (String key : params.keySet()) {
				paramStr.append(key + "="+ URLEncoder.encode(params.get(key).toString(), "utf-8") + "&");
			}
			byte[] data = paramStr.toString().getBytes();
			URL url = new URL(postUrl);
//			System.out.println(url+","+paramStr.toString());
			conn = (HttpURLConnection) url.openConnection();

			conn.setConnectTimeout(30*1000);
			conn.setDoOutput(true);
			conn.setUseCaches(false);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Connection", "Keep-Alive");
			conn.setRequestProperty("Charset", "UTF-8");
			conn.setRequestProperty("Content-Length", String.valueOf(data.length));
			//conn.setRequestProperty("Content-Type","text/plain");
//			conn.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
			outStream = new DataOutputStream(conn.getOutputStream());
			outStream.write(data);
			outStream.flush();
			outStream.close();
			String str = "发送失败!";
			if (conn.getResponseCode() == 200) {
				byte[] html = readStream(conn.getInputStream());
				str = new String(html, "UTF-8");
			}else{
				byte[] html = readStream(conn.getInputStream());
				str += new String(html, "UTF-8");
			}
			log.info("返回的数据："+str);
			return str;
		}catch(Exception e){
			try {
				log.error("http请求异常,本次http请求状态码为："+conn.getResponseCode()+"。 ",e);
			} catch (IOException e1) {
				log.error("",e1);
			}
			return "";
		}finally{
			try {
				outStream.flush();
				outStream.close();
			} catch (Exception e2) {
				log.error("输出流关闭失败",e2);
			}

		}

	}

	public static String doPost2(String url, Map<String, Object> params){
		CloseableHttpClient client = null;
		// 设置post参数
		List<NameValuePair> parameters = null;
		// 构造一个form表单式的实体
		UrlEncodedFormEntity formEntity = null;

		// 定义请求的参数
		if (params != null) {
			client = HttpClients.createDefault();
			// 设置post参数
			parameters = new ArrayList<NameValuePair>();
			for (Map.Entry<String, Object> entry : params.entrySet()) {
				// 添加参数
				parameters.add(new BasicNameValuePair(entry.getKey(), String
						.valueOf(entry.getValue())));
			}
			// 构造一个form表单式的实体
			try {
				formEntity = new UrlEncodedFormEntity(parameters,"UTF-8");
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}

		// 创建http GET请求
		HttpPost httpPost = null;
		if (formEntity != null) {
			httpPost = new HttpPost(url);
			// 将请求实体设置到httpPost对象中
			httpPost.setEntity(formEntity);
			// 伪装浏览器请求
			httpPost.setHeader(
					"User-Agent",
					"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.118 Safari/537.36");
		} else {
			httpPost = new HttpPost(url);
			// 伪装浏览器请求
			httpPost.setHeader(
					"User-Agent",
					"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.118 Safari/537.36");
		}
		RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();//设置请求和传输超时时间
		// 设置请求参数
		httpPost.setConfig(requestConfig);
		// 请求的结果
		CloseableHttpResponse response = null;
		try {
			// 执行请求
			response = client.execute(httpPost);
			// 判断返回状态是否为200
			if (response.getStatusLine().getStatusCode() == 200) {
				// 获取服务端返回的数据,并返回
				return EntityUtils.toString(response.getEntity(), "UTF-8");
			}
		} catch (ClientProtocolException e) {
//			e.printStackTrace();
			log.error("HU-ERROR-00001：客户端协议例外",e);
		} catch (IOException e) {
			log.error("HU-ERROR-00002：IO异常",e);
		} finally {

		}
		return null;
	}

	public static String doPost(String postUrl, Map<String, Object> params) {
		log.info("发起http的post请求>>>>>>>>>>>>>>>"+postUrl+">>>>>>>>>>>"+ JSON.toJSONString(params));
		DataOutputStream outStream = null;
		HttpURLConnection conn =  null;
		try{
			StringBuffer paramStr = new StringBuffer();

			for (String key : params.keySet()) {
				paramStr.append(key + "="+ (params.get(key) == null ? "" : URLEncoder.encode(params.get(key).toString(), "utf-8")) + "&");
			}
			byte[] data = paramStr.toString().getBytes();
			URL url = new URL(postUrl);
//			System.out.println(url+","+paramStr.toString());
			conn = (HttpURLConnection) url.openConnection();

			conn.setConnectTimeout(30*1000);
			conn.setDoOutput(true);
			conn.setUseCaches(false);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Connection", "Keep-Alive");
			conn.setRequestProperty("Charset", "UTF-8");
			conn.setRequestProperty("Content-Length", String.valueOf(data.length));
			//conn.setRequestProperty("Content-Type","text/plain");
			conn.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
			outStream = new DataOutputStream(conn.getOutputStream());
			outStream.write(data);
			outStream.flush();
			outStream.close();
			String str = "发送失败!";
			if (conn.getResponseCode() == 200) {
				byte[] html = readStream(conn.getInputStream());
				str = new String(html, "UTF-8");
			}else{
				byte[] html = readStream(conn.getInputStream());
				str += new String(html, "UTF-8");
			}
			return str;
		}catch(Exception e){
			try {
				log.error("http请求异常,本次http请求状态码为："+conn.getResponseCode()+"。 ",e);
			} catch (IOException e1) {
				log.error("",e1);
			}
			return "";
		}finally{
			try {
				outStream.flush();
				outStream.close();
			} catch (Exception e2) {
				log.error("输出流关闭失败",e2);
			}

		}

	}

	public static byte[] readStream(InputStream inStream) throws Exception {
		byte[] buffer = new byte[1024];
		int len = -1;
		ByteArrayOutputStream outStream = new ByteArrayOutputStream();
		while ((len = inStream.read(buffer)) != -1) {
			outStream.write(buffer, 0, len);
		}
		byte[] data = outStream.toByteArray();
		outStream.close();
		inStream.close();
		return data;
	}

	public static void main(String[] args) {
		Map<String, Object> map= new HashMap<String, Object>();
		map.put("sign", "BLB");
		map.put("productType", 6);
//		map.put("startDate", "2017-01-01");
		map.put("productId", "883196063021170690");
//		String s = HttpUtil.post("http://120.76.218.179:9113/api/webProductType/findList",map);
		String s = HttpUtil.post("http://120.76.218.179:9113/api/webProduct/getProductList",map);
		System.out.printf(s);
//		log.error(s);
//		JAXRSClientFactory.create("", cls);
	}

}
