package com.bcxin.wechat.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * dto 和 map 的转换类
 * @author Majesty
 *
 */
public class DOM {

	private static Logger log  = LoggerFactory.getLogger(DOM.class);


	/**
	 * 将dto转换为map,包括dto的父类，而且不包括Object
	 * 
	 * @param o
	 * @return
	 * @throws Exception
	 */
	public static Map<Object, Object> dtm(Object o) {

		// 获得所有父类，除了Object
		Class<? extends Object> clz = o.getClass();
		List<Class<? extends Object>> allClass = new ArrayList<Class<? extends Object>>();
		while (!"java.lang.Object".equals(clz.getName())) {
			allClass.add(clz);
			clz = clz.getSuperclass();
		}

		Map<Object, Object> rtn = new HashMap<Object, Object>();
		String methodName = "";

		for (Class<? extends Object> c : allClass) {

			for (Field field : c.getDeclaredFields()) {
				String f = field.getName();
				methodName = "get" + f.replaceFirst(f.substring(0, 1), f.substring(0, 1).toUpperCase());
				try {
					Method m = c.getMethod(methodName);
					m.setAccessible(true);
					Object fieldVal = m.invoke(o);

					// 如果是日期类型的数据，转换格式
					if (fieldVal instanceof Date || fieldVal instanceof java.sql.Date) {
						fieldVal = new SimpleDateFormat("yyyy-MM-dd H:m:s").format(fieldVal);
					}

					rtn.put(f, fieldVal);

				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

		return rtn;
	}

	/**
	 * 将dto转换为map
	 * 
	 * @param o
	 * @param fm
	 *          日期字段输出格式
	 * @return
	 * @throws Exception
	 */
	public static Map<Object, Object> dtmWithDateFormat(Object o, String fm) {

	// 获得所有父类，除了Object
			Class<? extends Object> clz = o.getClass();
			List<Class<? extends Object>> allClass = new ArrayList<Class<? extends Object>>();
			while (!"java.lang.Object".equals(clz.getName())) {
				allClass.add(clz);
				clz = clz.getSuperclass();
			}

			Map<Object, Object> rtn = new HashMap<Object, Object>();
			String methodName = "";

			for (Class<? extends Object> c : allClass) {

				for (Field field : c.getDeclaredFields()) {
					String f = field.getName();
					methodName = "get" + f.replaceFirst(f.substring(0, 1), f.substring(0, 1).toUpperCase());
					try {
						Method m = c.getMethod(methodName);
						m.setAccessible(true);
						Object fieldVal = m.invoke(o);

					// 如果是日期类型的数据，转换格式
						if (fieldVal instanceof Date || fieldVal instanceof java.sql.Date) {
							fieldVal = new SimpleDateFormat(fm).format(fieldVal);
						}

						rtn.put(f, fieldVal);

					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}

		
		return rtn;
	}


	/**
	 * map转换为dto，map的key来自于sql查询的字段，value对应字段的查询结果，这里只映射单条。
	 * 使用此方法时，要确保dto的字段名称（全部大写以后）和sql的查询字段一一对应。
	 * 
	 * @param map
	 * @param model
	 *          实体dto，与页面jsp交互使用
	 * @return
	 */
	public static Object mtd(Map<Object, Object> map, Object model) {

		Class<? extends Object> clz = model.getClass();

		for (Method m : clz.getDeclaredMethods()) {
			String f = m.getName().substring(3); //获得方法名get/set后面的值，转换为字段
			String fieldName = f.replaceFirst(f.substring(0, 1), f.substring(0, 1).toLowerCase());//字段名
			Object obj = map.get(fieldName); //map中要有对应的key和字段名相同才调用
			Class<?> cls = null;
			if ("set".equals(m.getName().substring(0, 3)) && obj != null) {
				try {
					// log.debug(map.get(fieldName.toUpperCase()));
					// 得到字段类型
					cls = clz.getDeclaredField(fieldName).getType();
					// log.debug(cls.getName());

					// 如果是日期类型，就转换赋值
					if ("java.util.Date".equals(cls.getName())) {
						Date date = new SimpleDateFormat("yyyy-mm-dd H:m:s").parse(String.valueOf(obj));
						m.invoke(model, date);
						continue;
					}
					// 如果是short类型，就转换赋值
					if ("java.lang.Short".equals(cls.getName())) {
						Short s = (Integer.valueOf(String.valueOf(obj))).shortValue();
						m.invoke(model, s);
						continue;
					}
					// 如果是long类型，就转换赋值
					if ("java.lang.Long".equals(cls.getName())) {
						Long l = Long.valueOf(String.valueOf(obj));
						m.invoke(model, l);
						continue;
					}
					if ("java.lang.Integer".equals(cls.getName())) {
						Integer i = Integer.valueOf(String.valueOf(obj));
						m.invoke(model, i);
						continue;
					}
					if ("java.math.BigDecimal".equals(cls.getName())) {
						BigDecimal bd  = new BigDecimal(String.valueOf(obj));
						m.invoke(model, bd);
						continue;
					}

					//通用，修改时间
					if("update_time".equals(fieldName)){
						m.invoke(model, new Date());
					}
					if("update_by".equals(fieldName)){
						m.invoke(model, map.get("system_params_user_id"));
					}

					// 其他类型转换失败的，要特殊处理，请添加
					m.invoke(model, obj);

				} catch (Exception e) {
					log.info(cls.getName() + "类型转换失败，请添加类型转换细节>>>>>>DOM");
//					log.info(cls.getName() + "类型转换失败，请添加类型转换细节>>>>>>DOM",e);
					continue;
				}
			}
		}

		return model;
	}

	/**
	 * map转换为dto，map的key来自于sql查询的字段，value对应字段的查询结果，这里只映射单条。
	 * 使用此方法时，要确保dto的字段名称（全部大写以后）和sql的查询字段一一对应。
	 * 
	 * @param map
	 * @param model
	 *          实体dto，与页面jsp交互使用
	 * @param fm
	 *          SimpleDateFormat可以接收的日期格式，例如"yyyy-mm-dd h:m:s"
	 * @return
	 */
	public static Object mtdWithDateFormat(Map<Object, Object> map, Object model, String fm) {

		Class<? extends Object> clz = model.getClass();

		for (Method m : clz.getDeclaredMethods()) {
			String f = m.getName().substring(3);
			String fieldName = f.replaceFirst(f.substring(0, 1), f.substring(0, 1).toLowerCase());
			String methodName = m.getName();
			Object obj = map.get(fieldName.toUpperCase());
			Class<?> cls = null;
			if ("set".equals(methodName.substring(0, 3)) && obj != null) {
				try {
					// log.debug(map.get(fieldName.toUpperCase()));
					// 得到字段类型
					cls = clz.getDeclaredField(fieldName).getType();
					// log.debug(cls.getName());

					// 如果是日期类型，就转换赋值
					if ("java.util.Date".equals(cls.getName())) {
						Date date = new SimpleDateFormat(fm).parse(obj.toString());
						m.invoke(model, date);
						continue;
					}
					// 如果是short类型，就转换赋值
					if ("java.lang.Short".equals(cls.getName())) {
						Short s = ((Integer) obj).shortValue();
						m.invoke(model, s);
						continue;
					}
					// 如果是long类型，就转换赋值
					if ("java.lang.Long".equals(cls.getName())) {
						Long l = Long.valueOf(obj.toString());
						m.invoke(model, l);
						continue;
					}
					// 其他类型转换失败的，要特殊处理，请添加

					m.invoke(model, obj);

				} catch (IllegalArgumentException e) {
					log.debug(cls.getName() + "类型转换失败，请添加类型转换细节");
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

		return model;
	}

	public static void main(String[] args) throws Exception {
		/*
		 * Map<Object, Object> rtn = dtoToMap(new UserDTO(0,3,912012L, "val", new
		 * Date())); for (Object each : rtn.keySet()) {
		 * log.debug("key:  "+each +"  value:  "+ rtn.get(each)+"     "+
		 * each.getClass()); }
		 */
		/*
		 * Map<Object,Object> m = new HashMap<Object,Object>();
		 * m.put("CREATE_DATE_TIME", "2014-10-29 03:08:16"); m.put("CREATE_TIME",
		 * "2014-10-07 03:08:38"); m.put("ID", 1L); m.put("NAME", "李四");
		 * m.put("PWD", "456"); Object model = mapToDto(m, new UserAdmin());
		 * log.debug(model.toString());
		 */
	}
}
