package com.bcxin.wechat.test;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.core.service.SysUserService;
import com.bcxin.models.order.entity.OrderCompanyRelation;
import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.models.order.service.OrderCompanyRelationService;
import com.bcxin.models.order.service.OrderFormService;
import com.bcxin.models.product.util.SendEmailAndMsgUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import com.bcxin.util.IdWorker;
import com.bcxin.wechat.weixin.util.WeixinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;
import java.util.Random;


@Controller
@RequestMapping("test")
public class TestController extends BaseController {

    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private OrderFormService orderFormService;
    @Autowired
    private OrderCompanyRelationService orderCompanyRelationService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysCompanyService sysCompanyService;
    @ResponseBody
    @RequestMapping(value = "/test1")
    public String listData(Model model){
        String url ="https://api.weixin.qq.com/cgi-bin/tags/create?access_token=l9BuEGoY9RUweM_UFyw43oUHzcrBpTKKkU9IT1H7uX2FxLB-dIyqOJZYBuN8iocdEZiQGV0RAWgLgd1nLfV6KsQ4DBo9jNPt7m9jKA1lKpl8sU8zBqy380398D5k4I74CKQhAEAHPV";
        JSONObject j= new JSONObject();
        JSONObject json2=new JSONObject();
        json2.put("name","运营");
        j.put("tag", json2);
        System.out.printf(j.toJSONString());
        System.out.printf(WeixinUtil.postJson(j,url).toString());
        return  null;
    }
    @ResponseBody
    @RequestMapping(value = "/test2")
    public void job1() {
        log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，保险公司同步开启");
        OrderForm orderForm2=new OrderForm();
           orderForm2.preInsert();//
        OrderForm orderForm= orderFormService.selectOne(new EntityWrapper().addFilter("web_order_form_id={0}",615));
        orderForm2.getId();
     orderForm.getOrderNumber();
        orderForm.getProvince();
        orderForm.getCity();

       int i= (int) ((Math.random()*9+1)*1000);
       String s="pp"+i;
        orderForm.getDistrict();
        SendEmailAndMsgUtil.sendEmail("订单未找到归属的分销商","订单未找到归属的分销商,---表Order form :订单号（id）:"+orderForm.getId()+",这个专家没有升级成分销商（web_user_id）："+orderForm.getWebUserId()+"。操作：将专家升级成分销商后，将相对应的sys_company,relate_to_terminal复制到表order_company_relation","247523194@qq.com");

        log.info("WebQuartz>>>>>>>>>>>>ID生成"+  orderForm2.getId()+",");
        log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，保险公司同步结束"+orderForm.getOrderNumber()+",");
    }
    @ResponseBody
    @RequestMapping(value = "/test3/{userID}")
    public String findExportName(@PathVariable Long userID) {
        log.info("查询专家名字，升级分销商用"+userID);

        SysUser sysUser= sysUserService.selectOne(new EntityWrapper().addFilter("web_user_id={0}",userID));

        System.out.printf(sysUser.getRealName().toString());
        log.info("专家名字:"+sysUser.getRealName());
        return "专家名字:"+sysUser.getRealName();
    }
    @ResponseBody
    @RequestMapping(value = "/test4/{web_user_id}/{order_form_id}")
    public String set(@PathVariable Long web_user_id,@PathVariable Long order_form_id) {

        Map map= orderCompanyRelationService.findByOrderFormID(order_form_id);
        String company_id=String.valueOf(map.get("company_id"));
        String id=String.valueOf(map.get("id"));
        log.info("分销商关联:"+map.toString());
      if (("null".equals(company_id)||"".equals(company_id))){
          //查询升级成分销商没

              log.info("查询专家名字，升级分销商用" + web_user_id);
              SysUser sysUser = sysUserService.selectOne(new EntityWrapper().addFilter("web_user_id={0}", web_user_id));
          OrderForm orderForm= orderFormService.selectOne(new EntityWrapper().addFilter("id={0}",order_form_id));
              log.info("专家ID:" + sysUser.getId());
              Long userID = sysUser.getId();
              SysCompany sysCompany = sysCompanyService.selectOne(new EntityWrapper().addFilter("relate_to_terminal={0}", userID));
          if (sysCompany!=null) {
              log.info("升级后分销商ID:" + sysCompany.getId());

              OrderCompanyRelation orderCompanyRelation=new OrderCompanyRelation();

              orderCompanyRelation.setType(Integer.valueOf(String.valueOf(map.get("type"))));
              orderCompanyRelation.setId(Long.valueOf(String.valueOf(map.get("id"))));
              orderCompanyRelation.setOrderForm(orderForm);
                      orderCompanyRelation.setSysCompany(sysCompany);
              orderCompanyRelationService.save(orderCompanyRelation);

              return "分销商关联成功";
          }else {
              return "专家未升级成分销商，请先升级";
          }
      }else {
          return "分销商关联已订单";
      }



    }



}
