package com.bcxin.wechat.tag.service.impl;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.core.base.service.impl.BaseServiceImpl;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.wechat.tag.dao.WinXinTagDao;
import com.bcxin.wechat.tag.entity.WeiXinTag;
import com.bcxin.wechat.tag.service.WinXinTagService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
public class WinXinTagServiceImpl extends BaseServiceImpl<WinXinTagDao,WeiXinTag> implements WinXinTagService {


    @Override
    public String updateTagTicket(String tagId, String rtn) {

 //       {"ticket":"gQH47joAAAAAAAAAASxodHRwOi8vd2VpeGluLnFxLmNvbS9xL2taZ2Z3TVRtNzJXV1Brb3ZhYmJJAAIEZ23sUwMEmm
//                    3sUw==","expire_seconds":60,"url":"http:\/\/weixin.qq.com\/q\/kZgfwMTm72WWPkovabbI"}

        JSONObject json =JSONObject.parseObject(rtn);
        try{
            WeiXinTag tag = this.selectOne(new EntityWrapper().addFilter("tag_id={0}",tagId));
            tag.setTicket(json.getString("ticket"));
            tag.setUrl(json.getString("url"));
            this.save(tag);
        }catch (Exception ex ){
            ex.printStackTrace();
        }

        return json.getString("url");
    }
}
