package com.bcxin.wechat.sys.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysAreaRelation;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysRegion;
import com.bcxin.core.service.SysAreaRelationService;
import com.bcxin.core.service.SysRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * liyongqiang
 * 登陆模块
 * 2017-8-17
 */
@Controller
@RequestMapping("${weChatPath}/index")
public class WeCharIndexController extends BaseController {



    @Autowired
    private SysRegionService sysRegionService;

    @Autowired
    private SysAreaRelationService  sysAreaRelationService;

    /**
     * 查找该公司的区域限制
     * @return
     */
    @RequestMapping(value = "/getCompanyRegionJson" )
    @ResponseBody
    public  String   getCompanyRegionJson(Long  companyId){

        //查询公司所关联的销售区域
        SysAreaRelation areaRelation = new SysAreaRelation();
        areaRelation.setType(2);//设置分销商
        areaRelation.setSysCompany(new SysCompany(companyId));
        areaRelation.setDelFlag("0");
        List<SysAreaRelation> areaList=sysAreaRelationService.findList(areaRelation);

//
//        //查询所有城市
        List<SysRegion> list= sysRegionService.selectList(null);
        List<SysRegion> topList= new ArrayList<>();
        Map<String, List<SysRegion>> map = new HashMap<String, List<SysRegion>>();
        //根据上级id组装成map
        for (SysRegion region : list) {
            List<SysRegion>  rlist = null;
            if (region.getParentId() != null) {
                rlist = map.get(region.getParentId()+"");
                if(rlist==null){
                    rlist= new ArrayList<SysRegion>();
                }
                rlist.add(region);
                map.put(region.getParentId()+"", rlist);
                if(region.getParentId()==100000){
                    topList.add(region);
                }
            }

        }
//        //组装Json
//
        JSONArray  jsonArray= new JSONArray();




        for(SysAreaRelation area:areaList ){
            if(area.getProvince().getId()==0){
                //当省份无限的话代表所有都是无限
                JSONObject  json1 = new JSONObject();
                JSONObject  json = new JSONObject();
                json.put("name","不限");
                json.put("code","0");
                if(area.getCity().getId()==0){
                    json.put("city",buxian(1));
                }
                json1.put("region",json);
                jsonArray.add(json1);
                for(SysRegion region : topList) {
                    JSONObject  json2 = new JSONObject();
                    JSONObject  json3 = new JSONObject();
                    json2.put("name",region.getProvince());
                    json2.put("code",region.getId());
                    //组装城市不限
                    JSONArray  cityArray=new JSONArray();
                    JSONObject  city1=new JSONObject();
                    city1.put("name","不限");
                    city1.put("code","0");
                    city1.put("area",buxian(2));
                    cityArray.add(city1);
                    json2.put("city",buxian(1,map,area,cityArray,region));
                    json3.put("region",json2);
                    jsonArray.add(json3);
                }


            }else{
                for(SysRegion region : topList) {
                    //如果出现固定省份
                    if(area.getProvince().getId().toString().equals(region.getId().toString())){
                        JSONObject  json2 = new JSONObject();
                        JSONObject  json3 = new JSONObject();
                        json2.put("name",region.getProvince());
                        json2.put("code",region.getId());
                        //组装城市不限
                        JSONArray  cityArray=new JSONArray();
                        JSONObject  city1=new JSONObject();
                        city1.put("name","不限");
                        city1.put("code","0");
                        city1.put("area",buxian(2));
                        cityArray.add(city1);
                        json2.put("city",buxian(1,map,area,cityArray,region));
                        json3.put("region",json2);
                        jsonArray.add(json3);
                    }

                }

            }


        }


       return jsonArray.toString();

    }

    private JSONArray buxian(int i) {

        JSONArray  jsonArray= new JSONArray();
        if(i==1){
            //组装城市
            JSONObject  json = new JSONObject();
            json.put("name","不限");
            json.put("code","0");
            json.put("area",buxian(2));
            jsonArray.add(json);
        }
        if(i==2){
            //组装区域
            JSONObject  json = new JSONObject();
            json.put("name","不限");
            json.put("code","0");
            jsonArray.add(json);
        }
        return  jsonArray;
    }

    private JSONArray buxian(int i, Map<String, List<SysRegion>> map, SysAreaRelation area, JSONArray jsonArray, SysRegion region) {

        List<SysRegion> topList= map.get(region.getId()+"");
        if(topList==null){
            topList= new ArrayList<>();
        }

        if(i==1){
            //组装城市
            if(area.getCitytype().getId()==0){
                //当城市为不限的时候-查出所有城市
                for (SysRegion r : topList){
                    JSONObject  json = new JSONObject();
                    json.put("name",r.getCitytype());
                    json.put("code",r.getId());
                    //组装所有城市不限
                    JSONArray  areaArray = new JSONArray();
                    JSONObject  area1=new JSONObject();
                    area1.put("name","不限");
                    area1.put("code","0");
                    areaArray.add(area1);
                    json.put("area",buxian(2,map,area,areaArray,r));
                    jsonArray.add(json);
                }
            }else{
                //当城市固定的时候 ,去掉不限这个限制
                jsonArray= new JSONArray();
                for (SysRegion r : topList){

                    if(area.getCitytype().getId().toString().equals(r.getId().toString())){
                        //当出现固定城市的时候
                        JSONObject  json = new JSONObject();
                        json.put("name",r.getCitytype());
                        json.put("code",r.getId());
                        json.put("area",buxian(2,map,area,new JSONArray(),r));
                        jsonArray.add(json);
                    }
                }

            }


        }
        if(i==2){
            //组装区域
            if(area.getCity().getId()==0){
                //当区域为不限的时候-查出所有城市
                JSONObject  jsonCity = new JSONObject();
//                jsonCity.put("name","不限");
//                jsonCity.put("code","0");
//                jsonArray.add(jsonCity);
                for (SysRegion r : topList){
                    JSONObject  json = new JSONObject();
                    json.put("name",r.getCity());
                    json.put("code",r.getId());
                    jsonArray.add(json);
                }
            }else{
                //当区域固定的时候 ,去掉不限这个限制
                jsonArray= new JSONArray();
                for (SysRegion r : topList){
                    if(area.getCity().getId().toString().equals(r.getId().toString())){
                        //当出现固定区域的时候
                        JSONObject  json = new JSONObject();
                        json.put("name",r.getCity());
                        json.put("code",r.getId());
                        jsonArray.add(json);
                    }
                }

            }
        }
        return  jsonArray;
    }

    /**
     *
     * 查询所有 城市的json字符串
     *
     * @return
     */
    @RequestMapping(value = "/test" )
    @ResponseBody
    public  String   getRegionJson(){

        //查询所有城市
        List<SysRegion> list= sysRegionService.selectList(null);
        List<SysRegion> topList= new ArrayList<>();
        Map<String, List<SysRegion>> map = new HashMap<String, List<SysRegion>>();
        //根据上级id组装成map
        for (SysRegion region : list) {
            List<SysRegion>  rlist = null;
            if (region.getParentId() != null) {
                rlist = map.get(region.getParentId()+"");
               if(rlist==null){
                  rlist= new ArrayList<SysRegion>();
               }
                rlist.add(region);
                map.put(region.getParentId()+"", rlist);
                if(region.getParentId()==100000){
                    topList.add(region);
                }
            }

        }
        //组装Json

        JSONArray  jsonArray= new JSONArray();
        for (SysRegion region : topList) {
            JSONObject  json1 = new JSONObject();
            JSONObject  json = new JSONObject();
            json.put("name",region.getProvince());
            json.put("code",region.getId());
            json.put("city",huidiao(1,region,map));
            json1.put("region",json);
            jsonArray.add(json1);
        }
        return jsonArray.toString();
    }

    private JSONArray huidiao(int i, SysRegion region, Map<String, List<SysRegion>> map) {
        JSONArray  jsonArray= new JSONArray();
        List<SysRegion> topList= map.get(region.getId()+"");
        if(topList==null){
            topList= new ArrayList<>();
        }
        if(i==1){
            //组装城市

            for (SysRegion r : topList){
                JSONObject  json = new JSONObject();
                json.put("name",r.getCitytype());
                json.put("code",r.getId());
                json.put("area",huidiao(2,r,map));
                jsonArray.add(json);
            }
        }
        if(i==2){

            //组装区
            for (SysRegion r : topList){
                JSONObject  json = new JSONObject();
                json.put("name",r.getCity());
                json.put("code",r.getId());
                jsonArray.add(json);
            }

        }


        return jsonArray;

    }


}
