package com.bcxin.wechat.share.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConfig;
import com.bcxin.core.entity.SysRoleMenu;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.wechat.product.dao.WeiXinProductDao;
import com.bcxin.wechat.share.dao.WXShareMapper;
import com.bcxin.wechat.share.dao.WXShareProductMapper;
import com.bcxin.wechat.share.entity.WXShareProduct;
import com.bcxin.wechat.share.service.WXShareService;

import com.bcxin.wechat.util.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xiaoleilu.hutool.http.HttpUtil;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 类名称：SysUserServiceImpl
 * 类描述：SysUser 表业务逻辑层接口实现类
 * 创建人：liujinju
 */
@Service
@Transactional
public class WXShareServiceImpl implements WXShareService {

    @Autowired
    private WXShareMapper wxShareMapper;

    @Autowired
    private WeiXinProductDao weiXinProductDao;

    @Autowired
    private WXShareProductMapper wxShareProductMapper;

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(wxShareMapper.queryCnt(p),wxShareMapper.query(p));
    }

    @Override
    public boolean saveShareProduct(String activityId, String productId, String cid) {
        if(StringUtils.isNotEmpty(productId)){
            //删除一个产品一个机构一个活动的对应关系
            wxShareProductMapper.delete(new EntityWrapper<WXShareProduct>().addFilter("activity_id={0}",activityId).addFilter("company_id={0}",cid))   ;
            //保存产品关联关系
            String productIds[] = productId.split(",");
            for(int i=0;i<productIds.length;i++){
                WXShareProduct wxShareProduct=new  WXShareProduct();
                wxShareProduct.setActivityId(activityId);
                wxShareProduct.setCompanyId(cid);
                wxShareProduct.setProductId(productIds[i]);
                wxShareProductMapper.insert(wxShareProduct);
            }


        }else{
            return  false;
        }
        return true;
    }

    @Override
    public String getActivityProduct(String activityId, String cid) {
        List<WXShareProduct> list=wxShareProductMapper.selectList(new EntityWrapper().addFilter("activity_id={0}",activityId).addFilter("company_id={0}",cid));
        String  arrays="";
        for(int i=0;i<list.size();i++){
            WXShareProduct product=list.get(i);
            if(i==0){
                arrays=product.getProductId();
            }else{
                arrays=arrays+","+product.getProductId();
            }
        }

        return arrays;
    }

    @Override
    public PageResult getChangeProductListPage(Map p) {
        List<Map<String,Object>> list= weiXinProductDao.getChangeProductListPage(p);
        String  str ="";
        for (Map<String,Object> map:list){
           str +=map.get("productCode")+",";
        }
        str=str.substring(0,str.length()-1);
        //可以单独传入http参数，这样参数会自动做URL编码，拼接在URL中
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("product_codes", str);
        String result= HttpUtil.get(GlobalConfig.getConfig("BLB")+"/weixin/product/getProDetailByProCodes", paramMap);
//        System.out.printf(result);
        HashMap<String, Object> resultMap = new HashMap<>();
        List<Map> l = JSON.parseArray(result,Map.class);
        for(Map map:l){
            resultMap.put( map.get("product_code").toString(),map.get("fixed_premium"));
        }
        for (Map<String,Object> map:list){

            map.put("fixed_premium", resultMap.get(map.get("productCode")));
            String  jiage=resultMap.get(map.get("productCode")).toString();
            BigDecimal  bJiage=new BigDecimal(jiage);
            String  fee= map.get("fee")==null?"0":map.get("fee").toString();
            BigDecimal  bFee=new BigDecimal(fee);
            map.put("true_fee", bJiage.multiply(bFee).multiply(new BigDecimal("0.01")));
        };

        return new PageResult(weiXinProductDao.getChangeProductListPageCnt(p),list);
    }

    @Override
    public boolean isResponsibility(String cid) {

        int  count=weiXinProductDao.getProductCount(cid);
        if(count>0){
           return true;
        }
        return false;
    }

}