package com.bcxin.wechat.product.service.impl;

import com.bcxin.core.util.AuthUtil;
import com.bcxin.models.product.entity.ProductRelation;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.product.dao.WeiXinProductDao;
import com.bcxin.wechat.product.service.WeiXinProductService;
import com.bcxin.wechat.share.dao.WXShareProductMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;


@Service
@Transactional
public class WeiXinProductServiceImpl implements WeiXinProductService {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    WeiXinProductDao weiXinProductDao;


    @Autowired
    private WXShareProductMapper wxShareProductMapper;


    @Override
    public Page<Map<String, Object>> getProductAssignedList(Page<Map<String, Object>> page, Map<String, Object> map,String  distributionLevel) {
        map.put("distributionLevel",distributionLevel);
        page.setRecords(weiXinProductDao.getProductAssignedList(page,map));
        return page;
    }

    @Override
    public Map<String,Object> getChangeProductNum(String activityId, String cid) {

        return wxShareProductMapper.getChangeProductNum(activityId,cid);
    }

    @Override
    public Page<Map<String,Object>> getProductListPage(Page<Map<String, Object>> page, Map<String, Object> params, String distributionLevel) {
        String type = StrUtil.obj2Str(params.get("type"));

        //分销商需要做权限管控
        if(StrUtil.toInteger(type).equals(ProductRelation.PRODUCT_ONE)) {
            AuthUtil.dataScopeFilter(params, "pre.relation_id");
        }
        params.put("distributionLevel",distributionLevel);
        page.setRecords(weiXinProductDao.getProductList(page,params));
        return page;
    }
}