package com.bcxin.wechat.product.service.impl;

import com.bcxin.models.product.entity.ProductRelation;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.wechat.product.service.WeiXinProductRelationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;


@Service
@Transactional
public class WeiXinProductRelationServiceImpl implements WeiXinProductRelationService {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProductRelationService productRelationService;

    @Override
    public boolean saveProductRelation(String productIds, String companyId, Integer type) {

        try{
            String pids[]=productIds.split(",");
            for(String pid:pids){
                productRelationService.delete(new EntityWrapper<ProductRelation>().addFilter("product_id ={0} and  relation_id={1} and type=1",pid,companyId));
            }

        } catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
             return false;
        }

        return true;
    }
}