package com.bcxin.wechat.bill.service.impl;

import com.bcxin.enums.CompanyTypeEnum;
import com.bcxin.wechat.bill.dao.WxBillNewMapper;
import com.bcxin.wechat.bill.entity.BillOrderTotalView;
import com.bcxin.wechat.bill.entity.BillOrderView;
import com.bcxin.wechat.bill.service.WxBillNewService;
import com.bcxin.wechat.util.CTLUtil;
import com.bcxin.wechat.util.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理-日结订单 实现类
 * @author  hzp
 * @date 2016/05/16
 */
@Service
@Transactional(rollbackFor=Exception.class)
public class WxBillNewServiceImpl implements WxBillNewService {

    @Autowired
    private WxBillNewMapper wxBillNewMapper;

    /**微信登录机构类型*/
    private String wxCompanyTypeKey="weixin_login_company_type";

    /**
     * 汇总订单信息
     * @param map
     * @return
     */
    @Override
    public BillOrderTotalView selectBillOrderTotal(Map<Object,Object> map){
        if(map.containsKey(wxCompanyTypeKey)){
            if(CompanyTypeEnum.DISTRIBUTOR.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=分销商*/
                return wxBillNewMapper.selectDistributorBillOrderTotal(map);
            }else if(CompanyTypeEnum.RESOUCER.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=资源方*/
                return wxBillNewMapper.selectResourceBillOrderTotal(map);
            }
        }
        return null;
    }

    /**
     * 根据产品分类汇总订单信息
     * @param map
     * @return
     */
    @Override
    public List<BillOrderTotalView> selectBillOrderTotalByProduct(Map<Object,Object> map){
        if(map.containsKey(wxCompanyTypeKey)){
            if(CompanyTypeEnum.DISTRIBUTOR.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=分销商*/
                return wxBillNewMapper.selectDistributorBillOrderTotalByProduct(map);

            }else if(CompanyTypeEnum.RESOUCER.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=资源方*/
                return wxBillNewMapper.selectResourceBillOrderTotalByProduct(map);
            }
        }
        return null;
    }

    /**
     * 账单列表界面-分页
     * @param map
     * @return
     */
    @Override
    public PageResult selectBillOrderPage(Map<Object,Object> map){
        if(map.containsKey(wxCompanyTypeKey)){
            if(CompanyTypeEnum.DISTRIBUTOR.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=分销商*/
                return new PageResult(wxBillNewMapper.selectDistributorBillOrderPageCount(map),wxBillNewMapper.selectDistributorBillOrderPage(map));
            }else if(CompanyTypeEnum.RESOUCER.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=资源方*/
                return new PageResult(wxBillNewMapper.selectResourceBillOrderPageCount(map),wxBillNewMapper.selectResourceBillOrderPage(map));
            }
        }
        return null;
    }


    /**
     * 查询订单详情
     * @param map
     * @return
     */
    @Override
    public BillOrderView selectOrderDetail(Map<Object,Object> map){
        List<BillOrderView> list=wxBillNewMapper.selectDistributorOrderDetail(map);
        if(list!=null && list.size()>0) {
            return list.get(0);
        }
        return null;
    }

    /**
     * 查询订单支付状态
     * @param orderNo
     * @return
     */
    @Override
    public Map<String,Object> selectOrderPayStatus(String orderNo){
        return wxBillNewMapper.selectOrderPayStatus(orderNo);
    }

    @Override
    public List<BillOrderView> selectBillOrder(Map<Object,Object> map){
        if(map.containsKey(wxCompanyTypeKey)){
            if(CompanyTypeEnum.DISTRIBUTOR.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=分销商*/
                return wxBillNewMapper.selectDistributorBillOrderPage(map);
            }else if(CompanyTypeEnum.RESOUCER.getKey().equals(map.get(wxCompanyTypeKey))){
                /**机构类型=资源方*/
                return wxBillNewMapper.selectResourceBillOrderPage(map);
            }
        }
        return null;
    }
}
