package com.bcxin.wechat.bill.service.impl;

import com.bcxin.wechat.bill.dao.WxBillCommonMapper;
import com.bcxin.wechat.bill.service.WxBillCommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理- 公用接口实现类
 * @author  hzp
 * @date 2016/05/16
 */
@Service
@Transactional(rollbackFor=Exception.class)
public class WxBillCommonServiceImpl implements WxBillCommonService {

    @Autowired
    private WxBillCommonMapper wxBillCommonMapper;

    @Override
    public List<Map<String, Object>> selectDistributionWithLower(Map<Object,Object> map) {
        return wxBillCommonMapper.selectDistributionCompanyWithLower(map);
    }

    @Override
    public List<Map<String, Object>> selectDistributionByResource(Map<Object,Object> map) {
        return wxBillCommonMapper.selectDistributionCompanyByResource(map);
    }

    @Override
    public List<Map<String, Object>> selectSellAreaProvinceById(Map<Object,Object> map) {
        return wxBillCommonMapper.selectSellAreaProvinceById(map);
    }

    @Override
    public List<Map<String, Object>> selectSellAreaCityById(Map<Object,Object> map) {
        return wxBillCommonMapper.selectSellAreaCityById(map);
    }

    @Override
    public List<Map<String, Object>> selectSellAreaDistrictById(Map<Object,Object> map) {
        return wxBillCommonMapper.selectSellAreaDistrictById(map);
    }

    /**
     * 获取订单的项目活动信息
     * @param params
     * @return
     */
    @Override
    public List<Map<String,Object>> selectProjectNameByOrderList(Map<Object,Object> params){
        return wxBillCommonMapper.selectProjectNameByOrderList(params);
    }
}
