package com.bcxin.wechat.bill.service.impl;

import com.bcxin.core.entity.SysRegion;
import com.bcxin.core.service.SysRegionService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.wechat.bill.dao.WXBillMapper;
import com.bcxin.wechat.bill.service.WXBillService;
import com.bcxin.wechat.util.PageResult;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 类名称：SysUserServiceImpl
 * 类描述：SysUser 表业务逻辑层接口实现类
 * 创建人：liujinju
 */
@Service
@Transactional
public class WXBillServiceImpl implements WXBillService {

    @Autowired
    private WXBillMapper wxBillMapper;

    /**
     * 根据分销商机构ID 获得对应的产品类型
     *
     * @param p 用户登录的机构ID
     * @return
     */
    @Override
    public List<Map<Object, Object>> getProductTypeByCompanyId(Map<Object, Object> p) {
        return wxBillMapper.getProductTypeByCompanyId(p);
    }

    @Override
    public PageResult weixinQueryBillList(Map<Object, Object> p) {
        return new PageResult(wxBillMapper.weixinQueryBillListCnt(p),wxBillMapper.weixinQueryBillList(p));
    }

    @Override
    public List<Map<Object, Object>> queryById(Map<Object, Object> p) {
        return wxBillMapper.queryById(p);
    }

    /**
     * 是否支付，根据订单号
     */
    @Override
    public Map<Object,Object> isPay(Map<Object, Object> p) {
        return wxBillMapper.queryByOrderNo(p).get(0);
    }

    @Override
    public Map<Object,Object> getListTotalFee(Map<Object, Object> p) {
        return wxBillMapper.getListTotalFee(p);
    }

    /**
     * 得到省的下拉列表，就是某个机构关联的限制区域，如果是0就是全部省
     */
    @Override
    public List<Map<Object, Object>> getListProvince(Map<Object, Object> p) {
        List<Map<Object, Object>> l =  wxBillMapper.getListProvince(p);
        //如果有不限，就是,province_id 0的情况
        for(Map<Object,Object> m : l ){
            if("0".equals(String.valueOf(m.get("")))){ //获得所有省份的列表
               return wxBillMapper.getListProvinceAll(p);
            }
        }
        return l;
    }

    /**
     * 统计一个分销商/资源方，机构的本月佣金数，本月笔数
     */
    @Override
    public Map<Object, Object> cntCompany(Map<Object, Object> p) {
        return wxBillMapper.cntCompany(p).get(0);
    }


    /**
     * 获得登录的下级分销商
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @Override
    public List<Map> getLowLevelCompanyByCurrentCompany(Map p) {
        return wxBillMapper.getLowLevelCompanyByCurrentCompany(p);
    }

    /**
     * 获得登录的分销商对应的被分配的城市信息
     * @param p
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/12 16:49
     */
    @Override
    public Map getAreaInfo(Map p) {
        Map map = Maps.newHashMap();
        List<Map> list = wxBillMapper.isProvinceNoLimit(p);
        if(list.size()!=0){ //如果是省份不限，那么特殊处理
            map.put("province",wxBillMapper.getAllProvince(p));
            map.put("city",wxBillMapper.getAllCity(p));
        }else{
            map.put("province",wxBillMapper.getProvinceInfo(p));
            map.put("city",wxBillMapper.getCityInfo(p));
        }
        return map;
    }

    /**
     * 返回项目信息从账单关联订单后的列表信息中获取
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @Override
    public List<Map> getProjectFromBill(Map p) {
        return wxBillMapper.getProjectFromBill(p);
    }

    /**
     * 根据订单列表查询项目名称
     * @param p
     * @return
     */
    @Override
    public List<Map> selectProjectNameByOrderList(Map p){
        return wxBillMapper.selectProjectNameByOrderList(p);
    }

    @Override
    public List<Map> querySumBelowBill(Map p) {
        return wxBillMapper.querySumBelowBill(p);
    }
}