package com.bcxin.wechat.bill.service;

import com.bcxin.wechat.bill.entity.BillOrderTotalView;
import com.bcxin.wechat.bill.entity.BillOrderView;
import com.bcxin.wechat.util.PageResult;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理-日结订单 接口类
 * @author  hzp
 * @date 2016/05/16
 */
public interface WxBillNewService {
    /**
     * 汇总订单信息
     * @param map
     * @return
     */
    BillOrderTotalView selectBillOrderTotal(Map<Object,Object> map);

    /**
     * 根据产品分类汇总订单信息
     * @param map
     * @return
     */
    List<BillOrderTotalView> selectBillOrderTotalByProduct(Map<Object,Object> map);

    /**
     * 账单列表界面-分页
     * @param map
     * @return
     */
    PageResult selectBillOrderPage(Map<Object,Object> map);

    /**
     * 查询订单详情
     * @param map
     * @return
     */
    BillOrderView selectOrderDetail(Map<Object,Object> map);

    /**
     * 查询订单支付状态
     * @param orderNo
     * @return
     */
    Map<String,Object> selectOrderPayStatus(String orderNo);

    List<BillOrderView> selectBillOrder(Map<Object,Object> map);
}
