package com.bcxin.wechat.bill.service;

import com.bcxin.wechat.util.PageResult;

import java.util.List;
import java.util.Map;


public interface WXBillService {

	PageResult weixinQueryBillList(Map<Object, Object> p);

	List<Map<Object,Object>> queryById(Map<Object,Object> p);

	/**
	 * 是否支付，根据订单号
	 */
	Map<Object,Object> isPay(Map<Object,Object> p );

	/**
	 * 统计总收入
	 */
	Map<Object,Object> getListTotalFee(Map<Object,Object> p );

	/**
	 * 得到省的下拉列表，就是某个机构关联的限制区域，如果是0就是全部省
	 * @param p
	 * @return
	 */
	List<Map<Object,Object>> getListProvince(Map<Object,Object> p );

	/**
	 * 统计一个分销商/资源方，机构的本月佣金数，本月笔数
	 */
	Map<Object,Object> cntCompany(Map<Object,Object> p);

	/**
	 * 根据分销商机构ID 获得对应的产品类型
	 * @param p  用户登录的机构ID
	 * @return
	 */
	List<Map<Object,Object>> getProductTypeByCompanyId(Map<Object,Object> p );


	/**
	 * 获得登录的下级分销商
	 * @apiNote  作者 陈堂君
	 * @since 创建于 2018/4/11 16:23
	 */
    List<Map> getLowLevelCompanyByCurrentCompany(Map p);

	/**
	 * 获得登录的分销商对应的被分配的城市信息
	 * @apiNote  作者 陈堂君
	 * @since 创建于 2018/4/12 16:49
	 */
	Map getAreaInfo(Map p);

	/**
	 * 返回项目信息从账单关联订单后的列表信息中获取
	 * @apiNote  作者 陈堂君
	 * @since 创建于 2018/4/11 16:23
	 */
	List<Map> getProjectFromBill(Map p);

	/**
	 * 根据订单列表查询项目名称
	 * @param p
	 * @return
	 */
	List<Map> selectProjectNameByOrderList(Map p);

	List<Map> querySumBelowBill(Map p);
}