package com.bcxin.wechat.bill.entity;

import com.bcxin.enums.ProductTypeEnum;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 微信端-收入明细-日结收入统计
 * @author hzp
 */
public class BillOrderTotalView implements Serializable {

    /**当前机构订单收入 （没有扣除下级佣金）*/
    private BigDecimal currAmountTotal=BigDecimal.ZERO;
    /**下级机构订单收入 （没有扣除下级佣金）*/
    private BigDecimal lowerAmountTotal=BigDecimal.ZERO;
    /**当前机构净收入*/
    private BigDecimal currAmount=BigDecimal.ZERO;
    /**下级机构净收入*/
    private BigDecimal lowerAmount=BigDecimal.ZERO;
    /**已经结算金额*/
    private BigDecimal settleAmount=BigDecimal.ZERO;
    /**未结算金额*/
    private BigDecimal noSettleAmount=BigDecimal.ZERO;
    /**已结算数量*/
    private Integer settleCount=0;
    /**未结算数量*/
    private Integer noSettleCount=0;
    /**总得记录数*/
    private Integer totalCount=0;
    /**下级收入记录数，只统计收入金额>0*/
    private Integer lowerTotalCount=0;
    /**本级净收入记录数，只统计收入金额>0*/
    private Integer currTotalCount=0;
    /**产品类型*/
    private String productType;
    /**产品类型名称*/
    private String productTypeName;

    public BigDecimal getCurrAmountTotal() {
        return currAmountTotal;
    }

    public void setCurrAmountTotal(BigDecimal currAmountTotal) {
        this.currAmountTotal = currAmountTotal;
    }

    public BigDecimal getLowerAmountTotal() {
        return lowerAmountTotal;
    }

    public void setLowerAmountTotal(BigDecimal lowerAmountTotal) {
        this.lowerAmountTotal = lowerAmountTotal;
    }

    public BigDecimal getCurrAmount() {
        return currAmount;
    }

    public void setCurrAmount(BigDecimal currAmount) {
        this.currAmount = currAmount;
    }

    public BigDecimal getLowerAmount() {
        return lowerAmount;
    }

    public void setLowerAmount(BigDecimal lowerAmount) {
        this.lowerAmount = lowerAmount;
    }

    public BigDecimal getSettleAmount() {
        return settleAmount;
    }

    public void setSettleAmount(BigDecimal settleAmount) {
        this.settleAmount = settleAmount;
    }

    public BigDecimal getNoSettleAmount() {
        return noSettleAmount;
    }

    public void setNoSettleAmount(BigDecimal noSettleAmount) {
        this.noSettleAmount = noSettleAmount;
    }

    public Integer getSettleCount() {
        return settleCount;
    }

    public void setSettleCount(Integer settleCount) {
        this.settleCount = settleCount;
    }

    public Integer getNoSettleCount() {
        return noSettleCount;
    }

    public void setNoSettleCount(Integer noSettleCount) {
        this.noSettleCount = noSettleCount;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
        if(StringUtils.isNotEmpty(productType)){
            this.setProductTypeName(ProductTypeEnum.getAlias(productType));
        }
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }

    public Integer getLowerTotalCount() {
        return lowerTotalCount;
    }

    public void setLowerTotalCount(Integer lowerTotalCount) {
        this.lowerTotalCount = lowerTotalCount;
    }

    public Integer getCurrTotalCount() {
        return currTotalCount;
    }

    public void setCurrTotalCount(Integer currTotalCount) {
        this.currTotalCount = currTotalCount;
    }
}
