package com.bcxin.wechat.bill.dao;

import com.bcxin.core.base.dao.BasDao;
import com.bcxin.spring.annotation.MyBatisDao;

import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理- 公用Dao接口
 * @author  hzp
 * @date 2016/05/16
 */
@MyBatisDao
public interface WxBillCommonMapper extends BasDao {
    /**
     * 获取当前分销机构信息+ 机构下级分销商信息
     * @param map 当前分销商机构id
     * @return 分销商机构信息列表
     */
    List<Map<String,Object>> selectDistributionCompanyWithLower(Map<Object,Object> map);

    /**
     * 根据资源方查询销售区域下的所有分销商
     * @param map 资源方机构id
     * @return 分销商机构信息列表
     */
    List<Map<String,Object>> selectDistributionCompanyByResource(Map<Object,Object> map);

    /**
     * 根据机构id 查询对应销售区域省份
     * @param map
     * @return 返回省
     */
    List<Map<String,Object>> selectSellAreaProvinceById(Map<Object,Object> map);

    /**
     * 根据机构id 查询对应销售区域市、县
     * @param map
     * @return 返回省、市、县
     */
    List<Map<String,Object>> selectSellAreaCityById(Map<Object,Object> map);

    /**
     * 根据机构id查询对应销售区域
     * @param map
     * @return 返回省、市、县、区域
     */
    List<Map<String,Object>> selectSellAreaDistrictById(Map<Object,Object> map);

    /**
     * 根据订单列表查询对应的项目名称
     * @param params
     * @return 返回项目
     */
    List<Map<String,Object>> selectProjectNameByOrderList(Map<Object,Object> params);

}
