package com.bcxin.wechat.activity.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConfig;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.util.SysRegionUtil;
import com.bcxin.models.product.entity.ProductIns;
import com.bcxin.models.product.service.ProductInsService;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.wechat.activity.dao.WeChatExhibitionMapper;
import com.bcxin.wechat.activity.entity.WeCharActivity;
import com.bcxin.wechat.activity.service.WeCharActivityService;
import com.bcxin.wechat.activity.service.impl.WeChatExhibitionServiceImpl;
import com.bcxin.wechat.activity.util.ZipUtils;
import com.bcxin.wechat.product.service.WeiXinProductService;
import com.bcxin.wechat.util.CTLUtil;
import com.bcxin.wechat.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;



@Controller
@RequestMapping("${weChatPath}/activity")
public class WeCharActivityController extends BaseController {


    @Autowired
    private WeCharActivityService weCharActivityService;

    @Autowired
    private   ProductInsService  productInsService;

    @Autowired
    private  WeiXinProductService   weiXinProductService;

    @Autowired
    private WeChatExhibitionServiceImpl weChatExhibitionService;


    /**
     * 测试用（废弃）
     * @param params
     * @param model
     * @param req
     */
    @RequestMapping("/test")
    public void test(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        weCharActivityService.saveExpiredActivityList(DateUtil.getDate("yyyy-MM-dd"));
    }


    /**
     * 增加活动页面
     */
    @RequestMapping("/activityAdd")
    public String activityAdd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {

        return "wechat/activity/activity_add";
    }

    /**
     * 修改活动
     * @param params
     * @param model
     * @param req
     * @return
     */
    @RequestMapping("/activityUpd")
    public String activityUpd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        model.addAttribute("p",params);
        String  id= params.get("id")==null?null:params.get("id").toString();
        if(StringUtils.isEmpty(id)){
            return "wechat/activity/activity_add";
        }
        //展会的活动信息还包括，展位数量
//        WeCharActivity weCharActivity=weCharActivityService.selectById(id);
        Map map = weChatExhibitionService.getActivityInfoById(id);
        if(map==null){
            return "wechat/activity/activity_add";
        }
        model.addAttribute("activity",map);
        return "wechat/activity/activity_upd";
    }

    /**
     * 保存活动，增加
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:19
     */
    @RequestMapping("saveActivity")
    public @ResponseBody Map<String,Object> saveActivity(@RequestParam Map<Object, Object> params) throws Exception{
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weCharActivityService.saveActivity(p);
    }


    /**
     * 活动详情
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/activityDetatil")
    public String activityDetatil(@RequestParam Map<Object,Object> params, Model model) {
        String  id= params.get("id")==null?null:params.get("id").toString();
//        WeCharActivity weCharActivity=weCharActivityService.selectById(id);
        Map weCharActivity = weChatExhibitionService.getActivityInfoById(id);
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        if(weCharActivity==null){//如果活动ID为空，那么就是新增
            logger.info("活动初始化的参数是："+JSON.toJSONString(p));
            //查询出登录用户所属机构最近一次的展厅展位信息，方便用户信息录入
            Result result = weChatExhibitionService.getLastActivityExhibitions(p);
            logger.info("活动初始化获得的展会信息："+JSON.toJSONString(result));
            model.addAttribute("exhibitions",result.getData());
            return "wechat/activity/activity_add";
        }else{
            Map<String, Object>map  = weiXinProductService.getChangeProductNum(id,p.get("weixin_login_company_id").toString());
            if(map!=null&&map.size()>0){
                String num=map.get("num").toString();
                if(StringUtils.isNotEmpty(num)&&!"0".equals(num)){
                    model.addAttribute("num",num);
                }
                model.addAttribute("productIds",map.get("productIds"));
            }
        }
        model.addAttribute("activity",weCharActivity);
        return "wechat/activity/activity_detatil";
    }


    /**
     * 已下架活动
     * @param params
     * @param model
     * @param req
     * @return
     */
    @RequestMapping("/activityDetatilAgo")
    public String activityDetatilAgo(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        String  id= params.get("id")==null?null:params.get("id").toString();
        WeCharActivity weCharActivity=weCharActivityService.selectById(id);
        if(weCharActivity==null){
            return "wechat/activity/activity_add";
        }
        model.addAttribute("activity",weCharActivity);
        return "wechat/activity/activity_detatil_ago";
    }


    /**
     * 保存活动状态（上下架操作这个方法）
     * @param model
     * @param params
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping("saveActivityStatus")
    @ResponseBody
    public   Object saveActivityStatus(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);
        return weCharActivityService.saveActivityStatus(req, p);

    }

    /**
     * 活动二维码扫描
     * @param params
     * @param model
     * @param req
     * @return
     */
    @RequestMapping("/activityErweima")
    public String activityErweima(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        String  id= params.get("id")==null?null:params.get("id").toString();
        String  productId = params.get("productIds")==null?null:params.get("productIds").toString();
        WeCharActivity weCharActivity=weCharActivityService.selectById(id);
        if(weCharActivity==null){
            return "wechat/activity/activity_add";
        }
        model.addAttribute("activity",weCharActivity);
//        String productId=getRequest().getSession().getAttribute("weixin_product_id")==null?null:getRequest().getSession().getAttribute("weixin_product_id").toString();
//       //根据产品id查询产品信息
//        ProductIns  productIns= productInsService.selectById(productId);
//        model.addAttribute("productName",productIns.getName());
        //获取多个产品
//        param.put("productIds",productId);
//        String productIds=ZipUtils.gzip(productId);
        model.addAttribute("productName",weCharActivity.getActivityName());
//        StringBuffer url = new StringBuffer(GlobalConfig.getConfig("BLB")+"/weixin/product//win/detail/"+productId);
        StringBuffer url = new StringBuffer(GlobalConfig.getConfig("BLB")+"weixin/product/win/prolist/"+weCharActivity.getId());
        model.addAttribute("url",url);
        StringBuffer urlErweima = new StringBuffer(GlobalConfig.getConfig("BLB")+"weixin/product/win/prolist/mid/"+weCharActivity.getId());
        model.addAttribute("urlErweima",urlErweima);
//        try{
//            param.put("name",weCharActivity.getActivityName());
//            param.put("ex_province",weCharActivity.getProvince());
//            param.put("ex_city",weCharActivity.getCity());
//            param.put("ex_county",weCharActivity.getDistrict());
//            param.put("ex_address",weCharActivity.getAddress());
//            param.put("star_time",DateUtil.format(weCharActivity.getStartTime(),"yyyy-MM-dd"));
//            param.put("end_time",DateUtil.format(weCharActivity.getEndTime(),"yyyy-MM-dd"));
//            param.put("recommendCode",weCharActivity.getUserId());
//            param.put("ex_area",SysRegionUtil.getRegionNameById(Long.parseLong(weCharActivity.getProvince()))+ " "+SysRegionUtil.getRegionNameById(Long.parseLong(weCharActivity.getCity()))+" "+ SysRegionUtil.getRegionNameById(Long.parseLong(weCharActivity.getDistrict())));
//            url.append(ZipUtils.gzip(param.toString()));

//        }catch (Exception ex){
//            model.addAttribute("url",url.toString());
//        }
        return "wechat/activity/activity_erweima";
    }


    /**
     * 活动下架列表
     * @param params
     * @param model
     * @param req
     * @return
     */
    @RequestMapping("/activityListOffline")
    public String activityListOffline(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        return "wechat/activity/activity_list_offline";
    }


    /**
     * 活动下架列表数据填充（ajax 请求）
     * @param params
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping(value = "/queryActivityListOfflineData" , method = RequestMethod.POST)
    public @ResponseBody
    Object queryActivityListOfflineData(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
        Map<Object,Object> p = CTLUtil.init(req,params);
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        CTLUtil.out(weCharActivityService.queryActivityListOfflineData(p),resp);
        return null;
    }


    /**
     * 活动上架列表
     * @param params
     * @param model
     * @param req
     * @return
     */
    @RequestMapping("/activityListOnline")
    public String activityListOnline(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
//        String  productId=params.get("productId")==null?null:params.get("productId").toString();
//        if(StringUtils.isNotEmpty(productId)){
//            getRequest().getSession().setAttribute("weixin_product_id",productId);
//        }
        return "wechat/activity/activity_list_online";
    }


    /**
     * 活动上架数据填充（ajax 请求）
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 13:11
     * @param params 参数searchText => activity_name 活动名称和 address活动地址模糊搜索
     * @return
     */
    @RequestMapping(value = "/queryActivityListOnlineData" , method = RequestMethod.POST)
    public @ResponseBody Object queryActivityListOnlineData(@RequestParam Map<Object,Object> params) {
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(weCharActivityService.queryActivityListOnlineData(p),getResponse());
        return null;
    }





}
