package com.bcxin.wechat.activity.util;

import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.wechat.activity.service.WeCharActivityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * Created by Apple on 2017/11/2.
 */
@Component
@Lazy(false)
public class WebQuartz {
    private Logger logger = LoggerFactory.getLogger(WebQuartz.class);

    @Autowired
    private WeCharActivityService weCharActivityService;

    @Scheduled(cron = "0 0 1 * * ? ") // 每天凌晨1点，更新数据要过0晨
//    @Scheduled(cron = "0/50 * * * * ? ") // 每50秒，测试
    public void test() {
        logger.info("修改活动下架的定时任务>>>>>>>>>>>>>>开始：");
        weCharActivityService.saveExpiredActivityList(DateUtil.getDate("yyyy-MM-dd"));
        logger.info("修改活动下架的定时任务>>>>>>>>>>>>>>结束：");
    }

}
