package com.bcxin.wechat.activity.entity;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅表
 */
@TableName("exhibition_hall")
public class ExhibitionHall implements Serializable {

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ID_WORKER)
    private Long exhibition_hall_id;
    /**
     * 机构ID
     */
    private Long sys_company_id;
    /**
     * 活动ID
     */
    private Long activity_id;
    /**
     * 展厅名称
     */
    private String exhibition_hall_name;
    private Date create_time;
    private Long create_by;
    private Date update_time;
    private Long update_by;
    private int del_flag; // 0未删除，1是删除

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getSys_company_id() {
        return sys_company_id;
    }

    public void setSys_company_id(Long sys_company_id) {
        this.sys_company_id = sys_company_id;
    }
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getExhibition_hall_id() {
        return exhibition_hall_id;
    }

    public void setExhibition_hall_id(Long exhibition_hall_id) {
        this.exhibition_hall_id = exhibition_hall_id;
    }
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getActivity_id() {
        return activity_id;
    }

    public void setActivity_id(Long activity_id) {
        this.activity_id = activity_id;
    }

    public String getExhibition_hall_name() {
        return exhibition_hall_name;
    }

    public void setExhibition_hall_name(String exhibition_hall_name) {
        this.exhibition_hall_name = exhibition_hall_name;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getCreate_by() {
        return create_by;
    }

    public void setCreate_by(Long create_by) {
        this.create_by = create_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(Long update_by) {
        this.update_by = update_by;
    }

    public int getDel_flag() {
        return del_flag;
    }

    public void setDel_flag(int del_flag) {
        this.del_flag = del_flag;
    }
}
