package com.bcxin.wechat.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysCompanyContacts;
import com.bcxin.core.service.SysCompanyContactsService;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.wechat.account.dao.WXAccountMapper;
import com.bcxin.wechat.account.service.WXAccountService;
import com.bcxin.wechat.util.R;
import org.hibernate.validator.internal.util.Contracts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.List;
import java.util.Map;

/**
 * Created by Apple on 2017/8/23.
 */
@Service
@Transactional
public class WXAccountServiceImpl implements WXAccountService {

    @Autowired
    private WXAccountMapper wxAccountMapper;

    @Autowired
    private SysCompanyService sysCompanyService;

    @Autowired
    private SysCompanyContactsService sysCompanyContactsService;


    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据帐户ID获得 帐号信息
     */
    @Override
    public Map<Object, Object> getAccountInfo(Map<Object, Object> p) {
        //根据用户ID获得信息 weixin_login_user_id
        List<Map<Object,Object>> l  = wxAccountMapper.getAccountInfo(p);
        if(l.size()>0) return l.get(0);
        logger.info("WEIXIN-ERROR-001: 没查到用户信息");
        return null;
    }

    /**
     * 修改用户
     */
    @Override
    public R upd(Map<Object, Object> p) {
        logger.info("获得的参数是>>>>>>>>>>>>>>>>>"+ JSON.toJSONString(p));
        try{
            SysCompany sc = new SysCompany();
            sc.setId(Long.valueOf(String.valueOf(p.get("id"))));
            sc.setCompanyName(String.valueOf(p.get("company_name")));
            sc.setSubsidiaryName(String.valueOf(p.get("subsidiary_name")));
            sc.setAddress(String.valueOf(p.get("address")));
            sc.setBankName(String.valueOf(p.get("bank_name")));
            sc.setBankAccount(String.valueOf(p.get("bank_account")));
            sc.setBankAccountName(String.valueOf(p.get("bank_account_name")));
            sc.setBankPhone(String.valueOf(p.get("bank_phone")));
            sc.setBankCity(String.valueOf(p.get("bank_city")));
            sc.setBankProvince(String.valueOf(p.get("bank_province")));
            sc.setProvince(String.valueOf(p.get("province")));
            sc.setCity(String.valueOf(p.get("city")));
            sc.setDistrict(String.valueOf(p.get("district")));
            sc.setOrganizationCode(String.valueOf(p.get("organization_code")));
//            sc.setCompanyType(Integer.valueOf(String.valueOf(p.get("company_type"))));
            sc.setDocumentType(Integer.valueOf(String.valueOf(p.get("document_type"))));
//            sc.setTerminalType(Integer.valueOf(String.valueOf(p.get("terminal_type")))); //不可以修改终端用户类型 企业/个人

            SysCompanyContacts scc = new SysCompanyContacts();
            scc.setId(Long.valueOf(String.valueOf(p.get("contacts_id"))));
            scc.setEmail(String.valueOf(p.get("contacts_email")));
            scc.setName(String.valueOf(p.get("contacts_email")));
            scc.setContactsWay(String.valueOf(p.get("contacts_contacts_way")));

            if(sysCompanyService.updateById(sc) && sysCompanyContactsService.insertOrUpdate(scc)){
                return new R(true,"操作成功");
            }else{
                return new R(false,"操作失败");
            }

        } catch (Exception e) {
            logger.error("信用险，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }
}
