<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>定时任务信息维护列表</title>
</head>

<body>
<div class="animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content search-query">
                <form action="${ctx}/taskCron/list" method="post" id="searchForm" onsubmit="return false">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label class="control-label">关键字</label>
                            <div class="input-group">
                                <input type="text" class="form-control " name="name" placeholder="任务名称">
                                <span class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="doRefresh()">搜索</button>
                                </span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox-content">
                <div class="row row-lg">
                    <div class="col-sm-12">
                        <div class="example-wrap">
                            <div class="example">
                                <div id="toolbar" class="fixed-table-toolbar">
                                    <shiro:hasPermission name="product:type:edit">
                                        <button type="button" class="btn btn-primary " title="添加" onclick="member_show('添加','${ctx}/taskCron/form?modify=add',null,null,'900','400')">
                                            <i class="glyphicon glyphicon-plus">添加</i>
                                        </button>
                                    </shiro:hasPermission>
                                    <button type="button" class="btn btn-primary" title="刷新数据" onclick="refreshdiv()">
                                        <i class="glyphicon glyphicon-refresh">刷新数据</i>
                                    </button>
                                </div>

                                <table id="table"
                                       data-toggle="table"
                                       data-show-toggle="true"
                                <%--data-click-to-select="true"--%>
                                       data-show-export="true"
                                       data-show-columns="true"
                                       data-striped="true"
                                       data-pagination="true"
                                      <%-- data-sort-name="type"--%>
                                       data-url="${ctx}/taskCron/list"
                                       data-query-params="queryParams"
                                       data-side-pagination="server"
                                       data-cache="false"
                                     <%--  data-sort-order="desc"--%>
                                       data-toolbar="#toolbar">
                                    <thead>
                                    <tr>
                                        <th data-checkbox="true" data-field="ID" >选择</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="name" data-field="name">任务名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="targetObject" data-field="targetObject">执行对象</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="taskMethod" data-field="taskMethod">执行方法名称</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="cronExpression" data-field="cronExpression">执行表达式</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="createTime"  data-field="createTime">创建时间</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="updateTime" data-field="updateTime">修改时间</th>
                                        <th data-halign="center" data-align="center" data-field="isStatus" data-formatter="statusClass2">TASK状态</th>
                                        <th data-halign="center" data-align="center" data-sortable="true" data-sort-name="status" data-field="status" data-formatter="statusClass">状态</th>
                                        <th data-halign="center" data-align="center" data-formatter = "stateFormatter">操作</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<shiro:hasPermission name="task:cron:edit">
    <div id="buttons-start" class="hide">
        <a class="remove m-l-sm text-info" href="javascript:void(0)" onclick="member_start(this,'valueId')" title="启动">
            <i class="glyphicon glyphicon-expand"></i>
        </a>
    </div>
    <div id="buttons-stop" class="hide">
    <a class="remove m-l-sm text-danger" href="javascript:void(0)" onclick="member_stop(this,'valueId')" title="停止">
        <i class="glyphicon glyphicon-lock"></i>
    </a>
    </div>
</shiro:hasPermission>

<shiro:hasPermission name="task:cron:delete">
    <div id="status0" class="hide">
        <a class="like text-info" href="javascript:void(0)" onClick="member_del(this,'valueId','确认要冻结吗?',0)" title="冻结"><i class="glyphicon glyphicon-pause"></i></a>
    </div>
    <div id="status1" class="hide">
        <a class="like text-info" href="javascript:void(0)" onClick="member_del(this,'valueId','确认要启用吗?',1)" title="启用"><i class="glyphicon glyphicon-play"></i></a>
    </div>
</shiro:hasPermission>


<div id="buttonsHbox" class="hide">
    <shiro:hasPermission name="task:cron:form">
        <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='valueId'; member_show('查看','${ctx}/taskCron/form?id=' + id,'','','900','400')" title="查看">
            <i class="glyphicon glyphicon-zoom-in"></i>
        </a>
    </shiro:hasPermission>
<shiro:hasPermission name="task:cron:edit">
        <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='valueId';member_show('修改','${ctx}/taskCron/form?id=' + id+'&modify=modify','','','900','400')" title="修改">
            <i class="glyphicon glyphicon-edit"></i>
        </a>
</shiro:hasPermission>

</div>

<bcxinFooter>
    <script type="text/javascript">
        /**
         * 操作
         */
        function stateFormatter(value, row, index) {
            var html = $("#buttonsHbox").html();
            if(isNotNull(html)){
                html = html.replace(new RegExp('valueId', 'g'),row.id);
            }

            var html2 = $("#buttons-start").html();
            if(isNotNull(html2)){
                html2 = html2.replace("valueId",row.id);
            }
            var html3 = $("#buttons-stop").html();
            if(isNotNull(html3)){
                html3 = html3.replace("valueId",row.id);
            }
            var html4;
            if(row.isStart){
                html4 = html3;
            }else {
                html4 = html2;
            }

            var html6 = $("#status0").html();
            if(isNotNull(html6)){
                html6 = html6.replace("valueId",row.id);
            }
            var html7 = $("#status1").html();
            if(isNotNull(html7)){
                html7 = html7.replace("valueId",row.id);
            }
            var html8;
            if(row.status=='1'){
                html8=html6
            }else{
                html8=html7
            }

            return [html8,html4,html].join(" ");
        }

        function member_del(obj,id,title,status){
            layer.confirm(title,{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'DELETE',
                    dataType:'json',
                    url:'${ctx}/taskCron/status/'+id+'?status='+status,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.message,{icon:1,time:1000});
                            $('#table').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        function member_stop(obj,id){
            layer.confirm('确认要停止定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/stop/'+id,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.message,{icon:1,time:1000});
                            $('#table').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        function member_start(obj,id){
            layer.confirm('确认要启动定时任务吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/taskCron/start/'+id,
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.message,{icon:1,time:1000});
                            $('#table').bootstrapTable("refresh");
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }

        function statusClass(value) {
            if(value == '1'){
                return ' <span class="label label-primary">启用</span>';
            }
            if(value=='0'){
                return '<span class="label label-danger">停用</span>';
            }
        }

        function statusClass2(value,row) {
            if(row.isStart){
                return ' <span class="label label-primary">运行中</span>';
            }else{
                return '<span class="label label-danger">停止</span>';
            }
        }

        /*获取选中行对象*/
        function getContent(){
            var index = $("#table").find("tr.danger").data("index");
            return $("#table").bootstrapTable('getData')[index];
        }

        function setRatio(val) {
            return val+"%"

        }
        function setAmount(val) {
            return toDecimal(val);
        }

    </script>
</bcxinFooter>
</body>
</html>
