package com.bcxin.task.order;

import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.models.order.service.OrderFormService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.task.base.config.TaskConfig;
import com.bcxin.util.toolbox.DateUtil;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 订单定时任务
 * Created by playboy on 2017/6/14.
 */
@Service
public class OrderFromTask {

    private Logger logger = LoggerFactory.getLogger(TaskConfig.class);

    @Autowired
    private OrderFormService orderFormService;

    public void execute() {
        try {
            logger.debug("订单逾期定时任务开始");
            List<OrderForm> list = orderFormService.selectList(new EntityWrapper(new OrderForm()));
            List<OrderForm> listtemp = Lists.newArrayList();
            if (null != list & list.size() > 0) {
                for (OrderForm o : list) {
                    if (DateUtil.calculateTwoDateDvalue(o.getEndDate(), new Date()) < 1) {
                        o.setStatus(3);
                        listtemp.add(o);
                    }
                }
                orderFormService.updateBatchById(listtemp);
            }
            logger.debug("订单逾期定时任务结束");
        } catch (Exception e) {
            logger.debug("订单逾期定时任务启动失败:", e);
        }
    }
}
