package com.bcxin.task.bill;

import com.bcxin.core.dao.SysCompanyDao;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.models.agreement.dao.AgreementDao;
import com.bcxin.models.agreement.dao.AgreementFeeDao;
import com.bcxin.models.agreement.entity.Agreement;
import com.bcxin.models.agreement.entity.AgreementFee;
import com.bcxin.models.agreement.service.AgreementService;
import com.bcxin.models.bill.dao.NewBillDao;
import com.bcxin.models.bill.entity.Bill;
import com.bcxin.models.bill.service.BillService;
import com.bcxin.models.order.dao.OrderPaymentDao;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.task.base.config.TaskConfig;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bcxin.util.toolbox.StrUtil.getMapObject;
import static com.bcxin.util.toolbox.StrUtil.getMapString;

/**
 * 账单日结
 * Created by playboy on 2017/6/14.
 */
@Service
public class BillTask {

    public static final Integer SCALE = 2;

    private Logger logger = LoggerFactory.getLogger(TaskConfig.class);

    @Autowired
    private OrderPaymentDao orderPaymentDao;

    @Autowired
    private AgreementService agreementService;

    @Autowired
    private BillService billService;

    @Autowired
    private NewBillDao newBillDao;

    @Autowired
    private SysCompanyDao sysCompanyDao;

    @Autowired
    private AgreementFeeDao agreementFeeDao;

    @Autowired
    private AgreementDao agreementDao;

    public void execute() {
        try {
            logger.debug("账单日结");
            Map<String, Object> params = Maps.newHashMap();
            params.put("startDate", cn.hutool.core.date.DateUtil.lastMonth());//捞取一周以内的单子。
            logger.info("执行定时任务>>>>>>>>>>>>>>日结算单>>>>>>>>>>>" + params.get("startDate"));
            List<Map<String, Object>> list = Lists.newArrayList();
            //查询保险供应商的账单，因为保险供应商不存order_company_relation表，可以直接从商品表里面取
            List<Map<String, Object>> allSupplierNoRisk = orderPaymentDao.getInsuranceOrders(params);//supplier_id
//            setFee(allSupplierNoRisk);
            list.addAll(allSupplierNoRisk);
            //查询所有机构（除保险供应商）的账单
            List<Map<String, Object>> allNoInsuranceSupplier = orderPaymentDao.getOrderPaymentList(params);
            //  因为二三级分销商没有协议，所以取一级分销商的协议内容。
            allNoInsuranceSupplier = allNoInsuranceSupplier.stream().filter(s -> {
                if (s.get("agreementId") == null) {
                    // 根据公司ID，找出一级分销商的协议ID
                    String p = sysCompanyDao.get(Long.parseLong(getMapString(s, "companyId"))).getParentIds();
                    List<Long> companyIds = Arrays.stream(p.split(",")).map(s1 -> Long.valueOf(s1.trim())).collect(Collectors.toList());
                    Long companyId = companyIds.get(1);
                    Long productId = (Long) (s.get("productId"));
                    //根据机构，和机构类型，找出协议ID
                    List<Agreement> agreements = agreementDao.selectList(new EntityWrapper<Agreement>().addFilter("company_id={0} and type=2 and status=1", companyId));//一级协议必须是生效的
                    if (agreements.size() > 0) {
                        Long agreementId = agreements.get(0).getId();
                        // 根据产品ID和协议ID，找出agreement_fee对应的记录，并设置
                        List<AgreementFee> agreementFees = agreementFeeDao.selectList(new EntityWrapper<AgreementFee>().addFilter("product_id={0} and agreement_id={1} and tax_scope_start<={2} and tax_scope_end>={3}", productId, agreementId, s.get("fcy"), s.get("fcy")));
                        if (agreementFees.size() > 0) {
                            AgreementFee af = agreementFees.get(0);
                            s.put("agreementId", af.getAgreementId());
                            s.put("taxRate", af.getTaxRate());
                            s.put("taxScopeStart", af.getTaxScopeStart());
                            s.put("taxScopeEnd", af.getTaxScopeEnd());
                            s.put("fixedCost", af.getFixedCost());
                            s.put("calcMethod", af.getCalcMethod());
                            s.put("fixedAmount", af.getFixedAmount());
                        }
                    }
                }
                return true;
            }).collect(Collectors.toList());
            list.addAll(allNoInsuranceSupplier);
            if (list.size() > 0) {
                //  设置二三级分销商费率的时候，要小于上级分销商的费率，这个保存的时候要做个校验
                saveDayBill(list);
            } else {
                logger.debug("没有需要结算的数据");
            }
            logger.debug("更新记录:" + list.size() + "条");
            logger.debug("账单日结定时任务结束");
        } catch (Exception e) {
            e.printStackTrace();
            logger.debug("账单日结定时任务启动失败:", e);
        }
    }

    private void saveDayBill(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            //定义生成日结单重复问题，排除掉重复问题，根据 订单号，产品，机构
            //理论上这里不会存在重复，这里的判断似乎没有必要
            List<Bill> billExist = billService.getBillExist(map);
            if (billExist != null && billExist.size() > 0) {
                continue;
            }
            if (StringUtils.isNotEmpty(getMapString(map, "agreementId"))) {//有协议的才生成账单
                Bill bill = new Bill();
                bill.setOrderId(Long.parseLong(getMapString(map, "orderId")));
                bill.setOrderNumber(getMapString(map, "orderNumber"));
                bill.setOrderPaymentId(Long.parseLong(getMapString(map, "orderPaymentId")));
                bill.setCompanyId(Long.parseLong(getMapString(map, "companyId")));
                //这里做分销商的计算
                settlement(bill, map);
//            bill.setVerification("0");
//            bill.setStatus("0");
                bill.setType(getMapString(map, "type"));
                bill.setProductId(Long.parseLong(getMapString(map, "productId")));
                bill.setFcy(StrUtil.obj2BigDecimal(getMapObject(map, "actualPayment")));//fcy=actualPayment
                bill.setPayDate(DateUtil.parseDate(getMapObject(map, "payDate")));
                bill.setOrderDate(DateUtil.parseDate(getMapObject(map, "orderDate")));
                bill.setAgreementId(StringUtils.isBlank(getMapString(map, "agreementId")) ? null : Long.valueOf(getMapString(map, "agreementId")));
                bill.setFeeRate(StrUtil.obj2BigDecimal(getMapObject(map, "feeRate")));
                //将协议字段冗余
                bill.setTaxRate(StrUtil.obj2BigDecimal(getMapObject(map, "taxRate")));
                bill.setTaxScopeStart(StrUtil.obj2BigDecimal(getMapObject(map, "taxScopeStart")));
                bill.setTaxScopeEnd(StrUtil.obj2BigDecimal(getMapObject(map, "taxScopeEnd")));
                bill.setFixedCost(StrUtil.obj2BigDecimal(getMapObject(map, "fixedCost")));
                bill.setFixedAmount(StrUtil.obj2BigDecimal(getMapObject(map, "fixedAmount")));
                bill.setCalcMethod(getMapString(map, "calcMethod"));
                newBillDao.insertSelective(bill);
            }
        }
    }

    /**
     * 规则结算佣金
     * 分销商规则:2.3级分销商取1级分销商的计算方式,若费用比例则乘，否则
     * 佣金：若是费用比例，则（订单支付金额/(1+税率） - 固定成本）* 佣金比率；若是固定金额，则直接使用佣金比率作为佣金
     *
     * @param bill
     */
    private void settlement(Bill bill, Map<String, Object> map) {
        //  固定金额做了，还没测
        //feeRate有可能是比例，也有可能是具体数值
        BigDecimal actualPayment = StrUtil.obj2BigDecimal(StrUtil.getMapObject(map, "actualPayment")).setScale(SCALE, BigDecimal.ROUND_DOWN);//订单金额
        BigDecimal feeRate = StrUtil.obj2BigDecimal(StrUtil.getMapObject(map, "feeRate")).divide(new BigDecimal(100)).setScale(SCALE, BigDecimal.ROUND_DOWN);//费用比例,要除以100
        BigDecimal taxRate = StrUtil.obj2BigDecimal(StrUtil.getMapObject(map, "taxRate")).divide(new BigDecimal(100)).setScale(SCALE, BigDecimal.ROUND_DOWN);//税率,要除以100
        BigDecimal fixedCost = StrUtil.obj2BigDecimal(StrUtil.getMapObject(map, "fixedCost")).setScale(SCALE, BigDecimal.ROUND_DOWN);//固定成本
        //价格=价税金额/（1+税率）；
        bill.setPrice(actualPayment.divide(taxRate.add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).setScale(SCALE, BigDecimal.ROUND_DOWN));
        // 净价格=价格-固定成本-变动成本；这里没有变动成本，所以不减
        bill.setNetPrice(bill.getPrice().subtract(fixedCost).setScale(SCALE, BigDecimal.ROUND_DOWN));
        //费用=若固定，则直接取固定金额，若比例，则：费用=净价格*费用比例；
        if (AgreementFee.CALC_METHOD_RATIO.equalsIgnoreCase(StrUtil.getMapString(map, "calcMethod"))) {
            //费用比例
            bill.setCost(bill.getNetPrice().multiply(feeRate).setScale(SCALE, BigDecimal.ROUND_DOWN));
        } else {
            //固定金额
            bill.setCost(StrUtil.obj2BigDecimal(StrUtil.getMapObject(map, "feeRate")).setScale(SCALE, BigDecimal.ROUND_DOWN));
            //如果是二三级分销商，则
            if ((SysCompany.DISTRIBUTIONLEVEL_TWO + SysCompany.DISTRIBUTIONLEVEL_THREE).contains(StrUtil.getMapString(map, "distributionLevel")) || SysCompany.DISTRIBUTIONLEVEL_THREE.equals(StrUtil.getMapString(map, "distributionLevel"))) {
                bill.setCost(feeRate.multiply(new BigDecimal(100)).setScale(SCALE, BigDecimal.ROUND_DOWN));//这里为什么要乘回来？因为费用比例存的是百分比，例如6%，如果是固定金额，那就是7，代表7元。之前已经除以100，所以要乘回来
            }
        }
    }
}
