package com.bcxin.task.base.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.task.base.config.TaskConfig;
import com.bcxin.task.base.entity.TaskCron;
import com.bcxin.task.base.entity.TaskCronStatus;
import com.bcxin.task.base.service.TaskCronService;
import com.bcxin.task.base.service.TaskCronStatusService;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *
 * 定时任务处理
 * Created by playboy on 2017/6/13.
 */
@Controller
@RequestMapping("${systemPath}/taskCron")
public class TaskCronController extends BaseController {

    @Autowired
    private TaskCronService taskCronService;

    @Autowired
    private TaskCronStatusService taskCronStatusService;

    //list
    private static final String ADD = getViewPath("admin/task/task_cron_add");
    //view
    private static final String LIST = getViewPath("admin/task/task_cron_list");

    @RequiresPermissions("task:cron:list")
    @RequestMapping("")
    public String listView(Model model){
        return LIST;
    }


    @RequiresPermissions("task:cron:list")
    @RequestMapping("/list")
    @ResponseBody
    public String listData(Model model,TaskCron taskCron){
        Page<TaskCron> page =this.getPage();
        taskCron.setStatus(-1);
        if(StrUtil.isBlank(taskCron.getName())){
            taskCron.setName(null);
            taskCronService.selectPage(page,new EntityWrapper(taskCron));
        }else {
            taskCronService.selectPage(page,new EntityWrapper().like("name",taskCron.getName()));
        }
        List<TaskCron> list = Lists.newArrayList();
        for(TaskCron t:page.getRecords()){
            if(TaskConfig.getInstance().TASKS.get(t.getId())!=null){
                t.setIsStart(true);
            }else{
                t.setIsStart(false);
            }
            list.add(t);
        }
        page.setRecords(list);
        return jsonPage(page);
    }

    @RequiresPermissions("task:cron:form")
    @RequestMapping("/form")
    public String form(Model model,@RequestParam(required=false)Long id){
        String flag = this.getParameter("modify");
        if(id!=null) {
            TaskCron taskCron = taskCronService.selectById(id);
            model.addAttribute("taskCron", taskCron);
        }
        model.addAttribute("modify",flag);
        return ADD;
    }

    /**
     * 查看执行记录
     * @param model
     * @param taskId
     * @return
     */
    @RequiresPermissions("task:cron:status:form")
    @RequestMapping("/formStatus")
    public String formStatus(Model model,@RequestParam(required=false)Long taskId){
        TaskCronStatus status = new TaskCronStatus();
        status.setTaskId(taskId);
        Page<TaskCronStatus> page = taskCronStatusService.selectPage(this.getPage(),new EntityWrapper<>(status));
        return jsonPage(page);
    }

    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/edit")
    @ResponseBody
    public AjaxResult edit(Model model, TaskCron taskCron){
        String msg = beanValidator(taskCron);
        if(StrUtil.isNotBlank(msg)){
            return success(false,msg);
        }
        taskCronService.save(taskCron);
        return success(true,"操作成功");
    }

    /**
     * 停止
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/stop/{id}")
    @ResponseBody
    public AjaxResult stop(Model model,@PathVariable Long id){
        TaskConfig.getInstance().stop(id);
        return success(true,"操作成功");
    }

    /**
     * 启动
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:edit")
    @RequestMapping("/start/{id}")
    @ResponseBody
    public AjaxResult start(Model model,@PathVariable Long id){
        TaskCron taskCron = taskCronService.selectById(id);
        if(taskCron.getStatus().equals(taskCron.DEL_FLAG_DELETE)){
            return success(false,"不能启动已经失效的数据");
        }
        TaskConfig.getInstance().start(taskCron);
        return success(true,"操作成功");
    }

    /**
     * 冻结和解冻
     * @param model
     * @param id
     * @return
     */
    @RequiresPermissions("task:cron:delete")
    @RequestMapping(value = "/status/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public AjaxResult delete(Model model, @PathVariable Long id,@RequestParam Integer status){
        TaskCron taskCron = new TaskCron();
        taskCron.setId(id);
        taskCron.setStatus(status);
        taskCronService.updateById(taskCron);
        if(TaskConfig.getInstance().TASKS.get(id)!=null){
            return success(false,"正在运行中的定时任务不能被删除");
        }
        return success(true,"操作成功");
    }
}
