package com.bcxin.task.base.entity;

import com.bcxin.core.base.entity.BaseEntity;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableName;

import java.util.Date;

/**
 * 定时任务信息状态表
 * Created by playboy on 2017/6/14.
 */

@TableName("task_cron_status")
public class TaskCronStatus extends BaseEntity<TaskCronStatus> {

    /**
     * 任务ID
     */
    @TableField("task_id")
    private Long taskId;

    /**
     * 执行状态 (1:执行成功,2:执行失败)
     */
    @TableField("run_status")
    private Integer runStatus;

    /**
     * 执行开始时间
     */
    @TableField("run_start_time")
    private Date runStartTime;

    /**
     * 执行结束时间
     */
    @TableField("run_end_time")
    private Date runEndTime;

    /**
     * 错误信息
     */
    @TableField("error_message")
    private String errorMessage;

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Integer getRunStatus() {
        return runStatus;
    }

    public void setRunStatus(Integer runStatus) {
        this.runStatus = runStatus;
    }

    public Date getRunStartTime() {
        return runStartTime;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public Date getRunEndTime() {
        return runEndTime;
    }

    public void setRunEndTime(Date runEndTime) {
        this.runEndTime = runEndTime;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
