package com.bcxin.task.base.entity;

import com.bcxin.core.base.entity.DataEntity;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableName;
import org.hibernate.validator.constraints.NotBlank;

/**
 *
 * 定时任务配置类
 * Created by playboy on 2017/6/14.
 */
@TableName("task_cron")
public class TaskCron extends DataEntity<TaskCron> {

    /**
     * 任务名称
     */
    @TableField("name")
    @NotBlank(message = "任务名称不能为空")
    private String name;

    /**
     * 执行对象
     */
    @TableField("target_object")
    @NotBlank(message = "执行对象不能为空")
    private String targetObject;

    /**
     * 执行方法名称
     */
    @TableField("task_method")
    @NotBlank(message = "执行方法名称不能为空")
    private String taskMethod;

    /**
     * 执行率
     */
    @NotBlank(message = "执行名称不能为空")
    @TableField("cron_expression")
    private String cronExpression;

    /**
     * 是否启动
     */
    private transient boolean isStart;

    /**
     * 查询用实体
     */
    private transient TaskCron taskCron;

    public boolean getIsStart() {
        return isStart;
    }

    public void setIsStart(boolean start) {
        isStart = start;
    }

    public String getTaskMethod() {
        return taskMethod;
    }

    public void setTaskMethod(String taskMethod) {
        this.taskMethod = taskMethod;
    }

    public TaskCron getTaskCron() {
        return taskCron;
    }

    public void setTaskCron(TaskCron taskCron) {
        this.taskCron = taskCron;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTargetObject() {
        return targetObject;
    }

    public void setTargetObject(String targetObject) {
        this.targetObject = targetObject;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Override
    public Integer getStatus() {
        return super.getStatus();
    }
}
