package com.bcxin.rest.web.apis.controllers;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.comparator.VersionComparator;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.BjNwJwtUtil;
import com.bcxin.Infrastructures.utils.JwtCommonUtil;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.commons.ConfigRpcProvider;
import com.bcxin.api.interfaces.enums.LoginFromType;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.*;
import com.bcxin.api.interfaces.identities.responses.PrepareResetPasswordResponse;
import com.bcxin.api.interfaces.identities.responses.SignInResponse;
import com.bcxin.api.interfaces.tenants.SingleLoginRpcProvider;
import com.bcxin.api.interfaces.tenants.TenantXlcpRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.LoginUserResponse;
import com.bcxin.api.interfaces.tenants.responses.QualificationCredentialResponse;
import com.bcxin.rest.web.apis.configs.AreaCodeConfig;
import com.bcxin.rest.web.apis.configs.BJSSOConfig;
import com.bcxin.rest.web.apis.configs.V5AppConfig;
import com.bcxin.rest.web.apis.requests.CertificateRequest;
import com.bcxin.rest.web.apis.utils.*;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@RestController
@RequestMapping("/identity")
public class IdentityController extends ControllerAbstract {

    private final Logger logger = LoggerFactory.getLogger(IdentityController.class);

    private final IdentityRpcProvider identityRpcProvider;

    private final SingleLoginRpcProvider singleLoginRpcProvider;

    private final ConfigRpcProvider configRpcProvider;

    private final TenantXlcpRpcProvider tenantXlcpRpcProvider;

    private final RetryProvider retryProvider;

    private final RedisUtil redisUtil;
    private final V5AppConfig v5AppConfig;
    private final AreaCodeConfig areaCodeConfig;
    //北京心理测评：测评端获取免密URL接口
    private final String XLCP_COM_API = "/docking/testCenter/get/noSecret/url";
    //北京心理测评：管理端获取免密URL接口
    private final String XLCP_USER_API = "/docking/test/get/noSecret/url";

    @Value("${bjxlcp.headAddress:}")
    public String headAddress;
    @Value("${bjxlcp.secretKey:}")
    public String secretKey;
    @Value("${QRCodeAuth:defaultValue}")
    public  String QRCodeAuth;
    @Value("${randomFrom:defaultValue}")
    public  String randomFrom;

    @Value("${authURL:defaultValue}")
    public  String authURL;
    @Value("${appId:defaultValue}")
    public  String appId;
    @Value("${accessControl:defaultValue}")
    public  String accessControl;
    @Value("${generateQRCodeURL:defaultValue}")
    public  String generateQRCodeURL;
    @Value("${queryQRCodeStateURL:defaultValue}")
    public  String queryQRCodeStateURL;

    public IdentityController(IdentityRpcProvider identityRpcProvider,
                              SingleLoginRpcProvider singleLoginRpcProvider,
                              ConfigRpcProvider configRpcProvider,
                              TenantXlcpRpcProvider tenantXlcpRpcProvider,
                              RetryProvider retryProvider,
                              RedisUtil redisUtil, V5AppConfig v5AppConfig,AreaCodeConfig areaCodeConfig) {
        this.identityRpcProvider = identityRpcProvider;
        this.singleLoginRpcProvider = singleLoginRpcProvider;
        this.configRpcProvider = configRpcProvider;
        this.tenantXlcpRpcProvider = tenantXlcpRpcProvider;
        this.retryProvider = retryProvider;
        this.redisUtil = redisUtil;
        this.v5AppConfig = v5AppConfig;
        this.areaCodeConfig=areaCodeConfig;
    }

    @ApiOperation(value = "登入", response = SignInResponse.class)
    @PostMapping("/sign-in")
    public ResponseEntity<SignInResponse> signIn(@Valid @RequestBody SignInRequest request, HttpServletRequest httpServletRequest) {
        //app登录需要先判断;
        try {
            if (request.isFromMobile() && false) {
                ResponseEntity responseEntity = this.signBeforeChick(request);

                if (responseEntity != null) {
                    return responseEntity;
                }
            }
            request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
            SignInResponse response = this.identityRpcProvider.signIn(request);

            return this.ok(response);
        } catch (Exception ex) {
            throw ex;
        }
    }


    @ApiOperation(value = "融通单点登录")
    @GetMapping("/rt/sso/login")
    public String rtSsoLogin(@RequestParam("ticket") String ticket,@RequestParam(value = "path",required = false) String path, HttpServletRequest httpServletRequest, HttpServletResponse response) {
        //获取接口调用地址
        String rtThirdPartyUrl = configRpcProvider.getValueByKey("rtThirdPartyUrl");
        SignInResponse signInResponse = null;
        try {
            String url = rtThirdPartyUrl + "/seeyon/thirdpartyController.do?ticket=" + ticket;
            Map<String, List<String>> headers = HttpUtil.createGet(url).execute().headers();

            //获取用户名
            List<String> loginNameList = headers.get("LoginName");

            if (loginNameList != null && loginNameList.size() > 0) {
                String loginName = loginNameList.get(0);

                SsoLoginRequest request = new SsoLoginRequest();
                request.setUserName(loginName);
                request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
                signInResponse = identityRpcProvider.ssoLogin(request);
                //转换url
                String urlPath = "";
                if (StrUtil.isNotEmpty(path)) {
                     urlPath = URLEncoder.encode(path, "UTF-8");
                }
                response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?homeTemplateBoradType=rtpayTemplate&__network__=false&token=" + signInResponse.getToken()+"&path="+urlPath);
            } else {
                response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/index.html");
            }

        } catch (Exception e) {
            try {
                response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/index.html");
            } catch (Exception e1) {
                return "SSOLogoutError";
            }
        }

        return "SSOOK";

    }
    /**
     * 湖南单点
     */
    @GetMapping("/hunan/sso/login")
    public String hunanssoLogin(@RequestParam("userToken") String userToken, HttpServletRequest httpServletRequest,HttpServletResponse response) throws UnsupportedEncodingException {
        try {
            httpServletRequest.setCharacterEncoding("utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setCharacterEncoding("utf-8");
        SignInResponse signInResponse = null;
        if(!JwtCommonUtil.validationToken(userToken)){
            return "SSOLogoutError:validFail";
        }
        Map<String,String> hashMap = JwtCommonUtil.parseToken(userToken);
        String idNum = hashMap.get("sfz");
        SsoLoginRequest request = new SsoLoginRequest();
        request.setUserName(idNum);
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        try {
            signInResponse = identityRpcProvider.ssoLogin(request);
        } catch (Exception e) {
            return e.getMessage();
        }
        try {
            response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken());
        } catch (IOException e) {
            return "SSOLogoutError";
        }
        return "SSOOK";
    }

    @GetMapping("/hunan/out/sso/login")
    public String hunanOutSsoLogin(@RequestParam("userToken") String userToken, @RequestParam("state") String state, HttpServletRequest httpServletRequest,HttpServletResponse response) throws UnsupportedEncodingException {
        try {
            httpServletRequest.setCharacterEncoding("utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setCharacterEncoding("utf-8");
        SignInResponse signInResponse;
        userToken = Base64.decodeStr(userToken);
        if(StringUtils.isEmpty(userToken)){
            throw new BadTenantException("userToken参数内容不能为空！");
        }
        if(StringUtils.isEmpty(state)){
            throw new BadTenantException("state参数内容不能为空！");
        }
        Map<String,String> hashMap = JSON.parseObject(userToken,Map.class);
        String idNum = JwtCommonUtil.decryptSm4Token(hashMap.get("idNum"));
        if(StringUtils.isEmpty(idNum)){
            throw new BadTenantException("idNum参数内容不能为空！");
        }
        String name = JwtCommonUtil.decryptSm4Token(hashMap.get("name"));
        String phone = JwtCommonUtil.decryptSm4Token(hashMap.get("phone"));

        //获取用户，没有就自动创建
        String userName = singleLoginRpcProvider.saveLoginUserForLegalPerson(name,idNum,phone);

        SsoLoginRequest request = new SsoLoginRequest();
        request.setUserName(userName);
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        try {
            signInResponse = identityRpcProvider.ssoLogin(request);
        } catch (Exception e) {
            return e.getMessage();
        }
        try {
            String type = "&type="+state;
            response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken()+type);
        } catch (IOException e) {
            return "SSOLogoutError";
        }
        return "SSOOK";
    }

    /**
     * 广西、南宁单点
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "广西、南宁单点登录", response = SignInResponse.class)
    @PostMapping("/sso/login")
    public ResponseEntity<SignInResponse> ssoLogin(@Valid SsoLoginRequest request, HttpServletRequest httpServletRequest) {
        SignInResponse response = null;
        try {
            request.setUserNameForSSO();
            singleLoginRpcProvider.saveLoginUser(request.getUserName());
            request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
            response = this.identityRpcProvider.ssoLogin(request);
        } catch (Exception e) {
            return this.error(e.getMessage());
        }
        return this.ok(response);
    }

    @ApiOperation(value = "北京CA认证登录", response = SignInResponse.class)
    @RequestMapping("/ca/login")
    public void caLogin(@Valid CALoginRequest loginRequest, HttpServletRequest request, HttpServletResponse response) {
        try {
            singleLoginRpcProvider.checkAuth();
            if (areaCodeConfig.getAreaCode().equals("110100")) {
                String dnname = request.getHeader("dnname");
                if (StrUtil.isNotEmpty(dnname)) {
                    loginRequest.setUserNameForBJCA(dnname);
                }
            } else if (areaCodeConfig.getAreaCode().equals("430000")) {
                Cookie[] cookies = request.getCookies();
                try {
                    if (cookies == null)
                        cookies = new Cookie[0];
                    for (int i = 0; i < cookies.length; i++) {
                        Cookie cookie = cookies[i];
                        if ("KOAL_CERT_CN".equals(cookie.getName())) {
                            String userName = URLDecoder.decode(cookie.getValue(), "UTF-8");
                            loginRequest.setUserNameForHNCA(userName);
                        }
                    }
                } catch (UnsupportedEncodingException e) {
                    throw new BadTenantException(String.format("湖南数字证书异常;Exception=%s", e.toString()));
                }

            }

            if (StrUtil.isNotEmpty(loginRequest.getUserName())) {
                if (areaCodeConfig.getAreaCode().equals("110100")) {
                    LoginUserResponse loginUserResponse = singleLoginRpcProvider.findByIdNum(loginRequest.getUserName());
                    loginRequest.setUserName(loginUserResponse.getTelephone());
                }
                SignInResponse signInResponse = this.identityRpcProvider.ssoLoginByIdNum(loginRequest.getUserName(), IPUtils.getIpAddress(request));

                response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken());
            } else {
                response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/");
            }
        } catch (Exception e) {
            logger.error("北京CA认证登录失败", e);
            try {
                response.setCharacterEncoding("GB2312");
                response.getWriter().write(e.getMessage());
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @ApiOperation(value = "北京内外单点登录", response = SignInResponse.class)
    @GetMapping("/beijing/in/sso/login")
    public String beijingInSsoLogin(@RequestParam("token") String token, HttpServletRequest httpServletRequest,HttpServletResponse response) throws UnsupportedEncodingException {
        try {
            httpServletRequest.setCharacterEncoding("utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setCharacterEncoding("utf-8");
        SignInResponse signInResponse;
        Map<String,String> hashMap = new BjNwJwtUtil().verifyToken(token);
        String idNum = hashMap.get("idNo");
        if(StringUtils.isEmpty(idNum)){
            throw new BadTenantException("idNum参数内容不能为空！");
        }

        String userName = idNum;
        SsoLoginRequest request = new SsoLoginRequest();
        request.setUserName(userName);
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        try {
            signInResponse = identityRpcProvider.ssoLogin(request);
        } catch (Exception e) {
            return e.getMessage();
        }
        try {
            String type = "";
            response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken()+type);
        } catch (IOException e) {
            return "SSOLogoutError";
        }

        return "SSOOK";
    }

    @ApiOperation(value = "北京自然人单点登录", response = SignInResponse.class)
    @GetMapping("/sso/login/naturalPerson")
    public void ssoLoginNaturalPerson(HttpServletRequest req, HttpServletResponse res, SsoLoginRequest request) throws IOException {
        res.setContentType("text/html;charset=utf-8");
        res.setCharacterEncoding("UTF-8");
        PrintWriter pw = res.getWriter();
        SignInResponse response = null;
        try {
            Object userInfo = redisUtil.get("sso_natural:" + req.getParameter("code"));
            String userName = null;
            if (userInfo != null) {
                userName = userInfo.toString();
            } else {
                userName = singleLoginRpcProvider.saveLoginUserForNaturalPerson(request.getCode());
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    pw.write("<br/>");
                    pw.write("<h3>业务加载中断，请通过业务入口重新访问</h3>");
                    return;
                }
            }
            request.setUserName(userName);
            request.setIpAddress(IPUtils.getIpAddress(req));
            response = this.identityRpcProvider.ssoLogin(request);
            String state = req.getParameter("state");
            String type = "&type="+state;
            res.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + response.getToken()+type);
        } catch (Exception e) {
            pw.write("<br/>");
            pw.write("<h3>" + e.getMessage() + "</h3>");
        }
    }

    /**
     * 即将删除
     * <b> 互联网端 北京心理测评获取测评端或管理端访问地址（请求当前接口需access_token完成鉴权） </b>
     * @param ltype 0:app,1:平台端
     * @param ctype 0:机构管理,1:企业管理
     * @author ZXF
     * @create 2025/01/09 0009 13:46
     * @version
     * @注意事项 </b>
     */
    @ApiOperation(value = "北京心理测评获取测评端或管理端访问地址", response = ResponseEntity.class)
    @PostMapping("/organizations/{organizationId}/employees/{employeeId}/l/{ltype}/c/{ctype}/xlcp/login")
    @Deprecated
    public ResponseEntity xlcpLogin(@PathVariable  String organizationId,@PathVariable String employeeId,@PathVariable  int ltype,@PathVariable int ctype, HttpServletResponse response) {
        Map<String, String> map = Maps.newHashMap();
        String url="";
        String body="";
        try {
            if(1==1){
                return this.error("系统维护中暂停使用，具体开放时间待通知，给您带来不变，敬请谅解！");
            }
            //使用上下文比较准确
            XlcpLoginRequest loginRequest = singleLoginRpcProvider.getByEmployeeId(organizationId, employeeId);
            loginRequest.setLogin_type(ltype);
            loginRequest.setCompany_type(ctype);
            if (loginRequest.getLogin_type() == 0) {//app
                url = headAddress + XLCP_USER_API;
                map.put("company_id", loginRequest.getCompany_id());
                map.put("company_name", loginRequest.getCompany_name());
                map.put("id", loginRequest.getEmp_id());
                map.put("id_card", loginRequest.getId_card());
                map.put("name", loginRequest.getName());
                map.put("sex", loginRequest.getSex() + "");
                map.put("age", loginRequest.getAge() + "");
                map.put("timestamp", String.valueOf(System.currentTimeMillis()));
            } else {
                url = headAddress + XLCP_COM_API;
                String company_id = loginRequest.getCompany_id();
                if (loginRequest.getCompany_type() == 0) {
                    //如果是监管机构查所有机构数据
                    company_id = "";
                }
                map.put("company_id", company_id);
                map.put("organizationId", "216cb2144e46f326a4e6e6081e93dbd5f9c0c01c5e3a5ad0e6b92e28c43dccd4");
                map.put("timestamp", String.valueOf(System.currentTimeMillis()));
            }

            Map<String, String> mapBody = CashierMD5Util.buildRequestPara(map, "&secret_key=" + secretKey);
            body = JSONUtil.toJsonStr(mapBody);
            Map<String, String> mapRes = Maps.newHashMap();
            mapRes.put("url", url);
            mapRes.put("body", body);
            return this.ok(mapRes);
        } catch (Exception e) {
            logger.error("北京心理测评获取测评端或管理端访问地址.error：", e);
            throw new BadTenantException(e.getMessage());
        }
    }

    @ApiOperation(value = "北京心理测评排序加签", response = ResponseEntity.class)
    @PostMapping("/organizations/{organizationId}/xlcp/secret")
    public ResponseEntity xlcpLogin(@PathVariable  String organizationId, @RequestBody XlcpSecretRequest req) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if(userModel==null) {
            throw new UnAuthorizedTenantException("未授权用户");
        }
        if(1==1){
            return this.error("系统维护中暂停使用，具体开放时间待通知，给您带来不变，敬请谅解！");
        }
        Map<String, String> map = Maps.newHashMap();
        String url="";
        String body="";
        try {
            //使用上下文比较准确
            String employeeId = TenantContext.getInstance().getUserContext().get().getEmployeeId();
            String companyName = TenantContext.getInstance().getUserContext().get().getOrganName();
            String number = req.getNumber();
            String name = TenantContext.getInstance().getUserContext().get().getName();
            if(req.getLogin_type()==0){//app
                url = headAddress+XLCP_USER_API;
                map.put("company_id",organizationId);
                map.put("company_name",companyName);
                map.put("id",employeeId);
                map.put("id_card",number);
                map.put("name",name);
                map.put("sex",getGender(number)+"");
                map.put("age",getAge(number)+"");
                map.put("timestamp",String.valueOf(System.currentTimeMillis()));
            }else{
                url = headAddress+XLCP_COM_API;
                String company_id = organizationId;
                if(req.getCompany_type()==0){
                    //如果是监管机构查所有机构数据
                    company_id = "";
                }
                map.put("company_id",company_id);
                map.put("organizationId","216cb2144e46f326a4e6e6081e93dbd5f9c0c01c5e3a5ad0e6b92e28c43dccd4");
                map.put("timestamp",String.valueOf(System.currentTimeMillis()));
            }
            Map<String, String> mapBody = CashierMD5Util.buildRequestPara(map,"&secret_key="+secretKey);
            body = JSONUtil.toJsonStr(mapBody);
            Map<String,String> mapRes = Maps.newHashMap();
            mapRes.put("url",url);
            mapRes.put("body",body);
            return this.ok(mapRes);
        } catch (Exception e) {
            logger.error("北京心理测评获取测评端或管理端访问地址.error：", e);
            throw new BadTenantException(e.getMessage());
        }
    }

    private int getAge(String idCard){
        // 截取出生日期
        String birthDateString = idCard.substring(6, 14);
        // 根据出生日期计算年龄
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate birthDate = LocalDate.parse(birthDateString, formatter);
        LocalDate currentDate = LocalDate.now();
        Period period = Period.between(birthDate, currentDate);
        return period.getYears();
    }

    private int getGender(String idNumber) {
        // 获取倒数第二位字符
        char c = idNumber.charAt(idNumber.length() - 2);
        // 偶数为女性(2)，奇数为男性(1)
        return (Integer.parseInt(String.valueOf(c)) % 2 == 0) ? 2 : 1;
    }

    @ApiOperation(value = "北京心理测评结果回调", response = ResponseEntity.class)
    @PostMapping("/beijing/xlcp/callback")
    public ResponseEntity xlcpCallback(@Valid @RequestBody XlcpCallRequest callRequest) {
        if (!callRequest.isAuth()) {
            throw new BadTenantException(String.format("心理测评回调处理异常;Exception=sign验证失败"));
        }

        try {
            tenantXlcpRpcProvider.saveXlcp(
                    callRequest.getSerial_number(),
                    callRequest.getEmp_id(), callRequest.getCompany_id(),
                    callRequest.getProject_name(), callRequest.getFile_url(),
                    callRequest.getSuggestion(), callRequest.getContent(),
                    callRequest.getResult(),
                    callRequest.getResult_rule_tip());
            return this.ok(null);
        } catch (Exception e) {
            String errMsg = e.getMessage();
            if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("DataIntegrityViolationException")) {
                errMsg = "业务编号已存在，请勿重复推送";
            }
            throw new BadTenantException(String.format("心理测评回调处理异常;Exception=%s", errMsg));
        }
    }

    /**
     * <b> 北京心理测评第三方文件手动转存(补偿用) </b>
     * @author ZXF
     * @create 2025/07/08 0008 15:20
     * @version
     * @注意事项 </b>
     */
    @GetMapping("/beijing/xlcp/zc")
    public String xlcpZC(HttpServletRequest req) {
        String sign = req.getParameter("sign");
        String day = req.getParameter("day");
        if(!"01RiIc5eG23a5P90E3jBo2Wbtt9Nd".equals(sign)){
            return "0";
        }
        tenantXlcpRpcProvider.updateXlcpFile(Integer.parseInt(day));
        return "1";
    }

    @ApiOperation(value = "获取北京自然人单点登录跳转地址")
    @GetMapping("/sso/redirectUrl/naturalPerson")
    public ResponseEntity getRedirectUrlForNaturalPerson() throws UnsupportedEncodingException {
        return this.ok(singleLoginRpcProvider.getRedirectUrlForNaturalPerson());
    }

    @ApiOperation(value = "获取北京法人单点登录跳转地址")
    @GetMapping("/sso/redirectUrl/legalPerson")
    public ResponseEntity getRedirectUrlForLegalPerson() {
        return this.ok(BJSSOConfig.redirectUrl);
    }

    @ApiOperation(value = "北京法人单点登录", response = SignInResponse.class)
    @GetMapping("/sso/login/legalPerson")
    public void ssoLoginLegalPerson(HttpServletRequest req, HttpServletResponse res, SsoLoginRequest request) throws IOException {
        res.setContentType("text/html;charset=utf-8");
        res.setCharacterEncoding("UTF-8");
        PrintWriter pw = res.getWriter();
        SignInResponse response = null;
        try {
            Object userInfo = redisUtil.get("sso:" + req.getParameter("code"));
            String userInfoStr = null;
            if (userInfo == null) {
                userInfoStr = new YZTAuthUtil().doAuth(req, true);
                if (StrUtil.isEmpty(userInfoStr)) {
                    pw.print("获取用户的信息为空");
                    pw.print(req.getAttribute("yzt_login_ermsg"));
                } else {
                    redisUtil.set("sso:" + req.getParameter("code"), userInfoStr, 1800);
                }
            } else {
                userInfoStr = userInfo.toString();
            }

            JSONObject userInfoJson = JSONObject.parseObject(userInfoStr);

            String errorMsg = userInfoJson.getString("error_msg");
            if (StrUtil.isNotEmpty(errorMsg)) {
                pw.write("<br/>");
                pw.write("<h3>" + errorMsg + "</h3>");
            }

            String extProperties = userInfoJson.getString("extProperties");
            String idNum = YZTAuthUtil.resolveExtProperties(extProperties, "LEGAL_PERSON_ID");   // 法人证件号
            request.setUserName(idNum);
            request.setIpAddress(IPUtils.getIpAddress(req));
            response = this.identityRpcProvider.ssoLogin(request);
            res.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + response.getToken());
        } catch (Exception e) {
            pw.write("<br/>");
            pw.write("<h3>" + e.getMessage() + "</h3>");
        }
    }

    @ApiOperation(value = "北京法人单点登录（百保盾过来）", response = SignInResponse.class)
    @GetMapping("/sso/bbd/ssoLegalLogin")
    public String ssoBBDLogin(String token, HttpServletRequest request) {
        String paramStr = JwtCommonUtil.parseJWT1(token);
        if(StringUtils.isEmpty(paramStr)){
            return "";
        }
        Map<String,String> paramMap = JSON.parseObject(paramStr, Map.class);
        String username = singleLoginRpcProvider.saveLoginUserForLegalPerson(paramMap.get("certName"),paramMap.get("certNo"),paramMap.get("mobile"));
        AtomicReference<String> result = new AtomicReference<>();
        this.retryProvider.execute(() -> {
            SignInResponse response = null;
            try {
                response = this.identityRpcProvider.ssoLoginByIdNum(username, IPUtils.getIpAddress(request));
            } catch (Exception e) {
                ThreadUtil.sleep(1000);
                logger.error("北京法人单点登录（百保盾过来）(token={})业务失败",token,e);
                throw new BadTenantException("单点异常",e);
            }

            if(response!=null&&StringUtils.isNotEmpty(response.getToken())){
                result.set(response.getToken());
            }else{
                ThreadUtil.sleep(1000);
                throw new BadTenantException("法人信息未入库，轮询中...");
            }
        }, 3);
        return result.get();
    }

    @ApiOperation(value = "陕西政务网单点登录", response = SignInResponse.class)
    @GetMapping("/shanxi/out/sso/login")
    public void shanxiOutSsoLogin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("text/html;charset=utf-8");
        res.setCharacterEncoding("UTF-8");
        PrintWriter pw = res.getWriter();
        SignInResponse response = null;
        try {
            String authToken = req.getParameter("authToken");
            String state = req.getParameter("state");
            if(StringUtils.isEmpty(authToken)){
                throw new BadTenantException("authToken参数内容不能为空！");
            }
            Map<String,String> paramMap = JwtCommonUtil.SXZW_verifyToken(authToken);
            String userName = null;
            if(StringUtils.isEmpty(paramMap.get("PERSONID"))){
                throw new BadTenantException("PERSONID参数内容不能为空！");
            }
            if("0".equals(paramMap.get("TYPE"))){
                Object userInfo = redisUtil.get("sso_natural:" + paramMap.get("PERSONID"));
                if (userInfo != null) {
                    userName = userInfo.toString();
                } else {
                    userName = singleLoginRpcProvider.saveLoginUserForNaturalPerson(paramMap.get("PERSON"),paramMap.get("PERSONID"),paramMap.get("MOBILE"));
                }
            }else{
                userName = singleLoginRpcProvider.saveLoginUserForLegalPerson(paramMap.get("LEGALPERSON"),paramMap.get("LEGALPERSONID"),paramMap.get("BLRMOBILE"));
            }
            ThreadUtil.sleep(3000);
            SsoLoginRequest request = new SsoLoginRequest();
            request.setUserName(userName);
            request.setIpAddress(IPUtils.getIpAddress(req));
            response = this.identityRpcProvider.ssoLogin(request);

            //0212 自行招用保安员单位的备案;0213 保安服务公司设立分公司备案;0214 保安服务公司跨区域经营保安服务备案;0215 保安员证申领;0253 设立保安培训机构许可;0254 设立保安服务公司许可
            state = "021201".equals(state)?"v504":"021301".equals(state)?"v610":"021401".equals(state)?"v611":"021501".equals(state)?"v501":"025301".equals(state)?"v503":"025401".equals(state)?"v502":"";
            String type = "&type="+state;
            res.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + response.getToken()+type);
        } catch (Exception e) {
            pw.write("<br/>");
            pw.write("<h3>" + e.getMessage() + "</h3>");
        }
    }

    @GetMapping("/jc/in/sso/login")
    public String jcInSsoLogin(HttpServletRequest httpServletRequest,HttpServletResponse response) {
        try {
            httpServletRequest.setCharacterEncoding("utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setCharacterEncoding("utf-8");
        SignInResponse signInResponse;
        String jh = httpServletRequest.getParameter("jh");
        String sfz = httpServletRequest.getParameter("sfz");
        String username = "";
        if (StringUtils.isNotEmpty(jh)) {
            try {
                jh = Base64.decodeStr(jh);
            } catch (Exception e) {
                throw new BadTenantException("jh解析异常！");
            }
            //查询用户是否存在
            if (singleLoginRpcProvider.isUserByUserName(jh)) {
                username = jh;
            }
        }
        if (StringUtils.isEmpty(username) && StringUtils.isNotEmpty(sfz)) {
            try {
                sfz = Base64.decodeStr(sfz);
            } catch (Exception e) {
                throw new BadTenantException("sfz解析异常！");
            }
            if (singleLoginRpcProvider.isUserByUserName(sfz)) {
                username = sfz;
            }
        }
        if (StringUtils.isEmpty(username)) {
            throw new BadTenantException("用户不存在！");
        }
        //同身份证号5分钟内最多请求3次
        if (redisUtil.getRedisRepetition(4, "jc_in_sso_login:" + username)) {
            throw new BadTenantException("请求频繁，请5分钟后重试！");
        }
        SsoLoginRequest request = new SsoLoginRequest();
        request.setUserName(username);
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        try {
            signInResponse = identityRpcProvider.ssoLogin(request);
        } catch (Exception e) {
            return e.getMessage();
        }
        try {
            String type = "";
            response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken() + type);
        } catch (IOException e) {
            return "SSOLogoutError";
        }
        return "SSOOK";
    }

    /**
     * <b> 默认陕西政务网用于查询资格证，如果其他省用需要传areaCode（省编码标识） </b>
     * @author ZXF
     * @create 2025/11/19 0019 13:32
     * @version
     * @注意事项 </b>
     */
    @ApiOperation(value = "政务网资格证查询", response = SignInResponse.class)
    @PostMapping("/out/public/search")
    public @ResponseBody Object outPublicSearch(@RequestBody CertificateRequest request) {
        String url = "https://v5qy.baibaodun.cn/v3/public/qualification-credentials";
        String areaCode = "61";
        if(StringUtils.isNotEmpty(request.getAreaCode())){
            areaCode = request.getAreaCode();
        }
        String body = String.format("{'idnum':'%s','areaCode':'%s'}",request.getKeyword(),areaCode);
        HttpResponse response = HttpUtil.createPost(url)
                .contentType("application/json")
                .body(body).execute();
        return JSON.parseObject(response.body());
    }

    @ApiOperation(value = "修改密码", response = SignInResponse.class)
    @PostMapping("/change-password")
    public ResponseEntity changePassword(
            @Valid @RequestBody com.bcxin.rest.web.apis.requests.ChangePasswordRequest request,
            HttpServletRequest servletRequest) {
        ChangePasswordRequest changePasswordRequest = request.getRequest(servletRequest);
        this.identityRpcProvider.changePassword(changePasswordRequest);

        return this.ok(null);
    }

    @ApiOperation(value = "微信登入", response = SignInResponse.class)
    @PostMapping("/wechat-in")
    public ResponseEntity<SignInResponse> sso_login(@RequestBody WeChatSignInRequest request, HttpServletRequest httpServletRequest) {

        ResponseEntity responseEntity = this.signBeforeChick(request);

        if (responseEntity!=null) {
            return responseEntity;
        }
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        SignInResponse response = this.identityRpcProvider.signIn(request);

        return this.ok(response);
    }

    @ApiOperation(value = "忘记密码前的验证证件号是否存在")
    @PostMapping("/prepare-reset-password-exist")
    public ResponseEntity prepareResetPasswordExist(@RequestBody PrepareResetPasswordRequest request) {
        PrepareResetPasswordResponse response = this.identityRpcProvider.prepareResetPasswordExist(request);
        return this.ok(response);
    }

    @ApiOperation(value = "忘记密码前的验证操作(短信/人脸)")
    @PostMapping("/prepare-reset-password")
    public ResponseEntity prepareResetPassword(@RequestBody PrepareResetPasswordRequest request) {
        PrepareResetPasswordResponse response = this.identityRpcProvider.prepareResetPassword(request);
        return this.ok(response);
    }

    @ApiOperation(value = "通过忘记密码前的操作验证验证码")
    @PostMapping("/prepare-reset-password-check-code")
    public ResponseEntity prepareResetPasswordCheckCode(@RequestBody ResetPasswordRequest request) {
        this.identityRpcProvider.prepareResetPasswordCheckCode(request);

        return this.ok();
    }
    @ApiOperation(value = "通过忘记密码前的操作执行密码修改")
    @PostMapping("/reset-password")
    public ResponseEntity resetPassword(@RequestBody ResetPasswordRequest request) {
        this.identityRpcProvider.restPassword(request);

        return this.ok();
    }

    @ApiOperation(value = "通过密码和token解锁账号")
    @PostMapping("/unlock")
    public ResponseEntity unlock(@RequestBody UnlockRequest request) {
        String userId = this.getCurrentUserId();
        request.setUserid(userId);
        String token = this.identityRpcProvider.unlock(request);
        return this.ok(token);
    }

    //登录前校验
    public ResponseEntity  signBeforeChick(RequestAbstract request) {
        String v5VersionKey = "v5Version";
        String v5WgtVersionKey = "v5WgtVersion";
        String v5UpdateMsgKey = "v5UpdateMsg";
        if (request.getLoginFrom() != null && request.getLoginFrom() == LoginFromType.BKT) {
            v5VersionKey = "v5BktVersion";
            v5WgtVersionKey = "v5BktWgtVersion";
            v5UpdateMsgKey = "v5BktUpdateMsg";
        }

        //百保盾app登录进入这个分支
        if (request.getLoginFrom() == null || request.getLoginFrom() != LoginFromType.WECHAT_CGI) {
            String v5Version = configRpcProvider.getValueByKey(v5VersionKey);
            String v5WgtVersion = configRpcProvider.getValueByKey(v5WgtVersionKey);
            String v5UpdateMsg = configRpcProvider.getValueByKey(v5UpdateMsgKey);
            if (StrUtil.isEmpty(request.getVersion()) || StrUtil.isEmpty(request.getWgtVersion())) {
                return this.status(HttpStatus.OK, v5UpdateMsg);
            }
            int compareVersion = VersionComparator.INSTANCE.compare(request.getVersion(), v5Version);
            int compareWgtVersion = VersionComparator.INSTANCE.compare(request.getWgtVersion(), v5WgtVersion);
            //判断大版本
            if (compareVersion < 0) {
                return this.status(HttpStatus.OK, v5UpdateMsg);
            }
            //大版本一样判断小版本
            if (compareVersion == 0) {
                if (compareWgtVersion < 0) {
                    return this.status(HttpStatus.OK, v5UpdateMsg);
                }
            }
        }

        return null;
    }

    @PostMapping("/shanxi/pki/login")
    @ResponseBody
    public AjaxResult shanXiPkiLogin(String username) {
        if (!username.equals("bbd_manager")){
            JitGatewayUtil jitGatewayUtil = new JitGatewayUtil(authURL, appId, randomFrom, accessControl, generateQRCodeURL, queryQRCodeStateURL);
            Object qrCodeAuthObj = QRCodeAuth;
            String qrCodeAuthStr = String.valueOf(qrCodeAuthObj);
            String randNum = null;
            if ("false".equals(qrCodeAuthStr)) {
                randNum = jitGatewayUtil.generateRandomNum(randomFrom);
                if (!jitGatewayUtil.isNotNull(randNum)) {
                    return new AjaxResult(false, "获取原文失败");
                }
            }
            Map data = new HashMap();
            data.put("original_data", randNum);
            data.put("QRCodeAuth", qrCodeAuthStr);
            data.put("original", randNum);
            return new AjaxResult(true, "成功", data);

        }else {
            return new AjaxResult(true, "成功", "login");
        }
    }
    @PostMapping("/gansu/pki/login")
    @ResponseBody
    public AjaxResult ganSuPkiLogin(String username) {
        if (!username.equals("gs_super")){
            JitGatewayUtil jitGatewayUtil = new JitGatewayUtil(authURL, appId, randomFrom, accessControl, generateQRCodeURL, queryQRCodeStateURL);
            Object qrCodeAuthObj = QRCodeAuth;
            String qrCodeAuthStr = String.valueOf(qrCodeAuthObj);
            String randNum = null;
            if ("false".equals(qrCodeAuthStr)) {
                randNum = jitGatewayUtil.generateRandomNum(randomFrom);
                if (!jitGatewayUtil.isNotNull(randNum)) {
                    return new AjaxResult(false, "获取原文失败");
                }
            }
            Map data = new HashMap();
            data.put("original_data", randNum);
            data.put("QRCodeAuth", qrCodeAuthStr);
            data.put("original", randNum);
            return new AjaxResult(true, "成功", data);

        }else {
            return new AjaxResult(true, "成功", "login");
        }
    }

    @ApiOperation(value = "甘肃数字证书单点登录")
    @RequestMapping("/jitGWAuth")
    @ResponseBody
    public AjaxResult authen(String authMode, String original, String signed_data, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil(authURL, appId, randomFrom, accessControl, generateQRCodeURL, queryQRCodeStateURL);
        jitGatewayUtil.jitGatewayUtilBean.setAuthMode("cert");
        jitGatewayUtil.jitGatewayUtilBean.setToken("");
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_data(original);
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_jsp(original);
        jitGatewayUtil.jitGatewayUtilBean.setSigned_data(signed_data);
        jitGatewayUtil.jitGatewayUtilBean.setRemoteAddr("");
        jitGatewayUtil.auth();
        if (!jitGatewayUtil.authResult.isSuccess()) {
            return new AjaxResult(false, "身份认证失败，失败原因：" + jitGatewayUtil.authResult.getErrDesc());
        }
        Map userMap = jitGatewayUtil.authResult.getCertAttributeNodeMap();
        if(userMap == null){
            return new AjaxResult(false, "未获取到匹配用户信息");
        }
        String key = "_saml_pki_cert_subject";
        String userName = "";
        String val = userMap.get(key).toString();
        try {
            userName = val.split(",")[0].split(" ")[1];
        } catch (Exception e) {
            return new AjaxResult(false, "证书信息解析失败，原数据："+val);
        }

        if(StringUtils.isEmpty(userName)){
            return new AjaxResult(false, "未获取到用户账号信息");
        }

        SsoLoginRequest ssoLoginRequest = new SsoLoginRequest();
        ssoLoginRequest.setUserName(userName);
        ssoLoginRequest.setIpAddress(IPUtils.getIpAddress(request));
        SignInResponse signInResponse = this.identityRpcProvider.ssoLogin(ssoLoginRequest);
//        response.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + signInResponse.getToken());
        return new AjaxResult(true, "身份认证成功。", signInResponse.getToken());
    }

    @ApiOperation(value = "甘肃政务网单点登录")
    @GetMapping("/gs/out/sso/login")
    public void   gsLoginLegalPerson(@RequestParam("ticket") String ticket, @RequestParam("state") String state,@RequestParam("loginType") String loginType,HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("text/html;charset=utf-8");
        res.setCharacterEncoding("UTF-8");
        SignInResponse response = null;
        PrintWriter pw = res.getWriter();
        if(StringUtils.isEmpty(ticket)){
            throw new BadTenantException("ticket参数内容不能为空！");
        }
        if(StringUtils.isEmpty(state)){
            throw new BadTenantException("state参数内容不能为空！");
        }
        if(StringUtils.isEmpty(loginType)){
            throw new BadTenantException("loginType参数内容不能为空！");
        }
        SsoLoginRequest request = new SsoLoginRequest();
        try {
            String userinfoUrl ="https://zwfw.gat.gansu.gov.cn/seeyon/thirdpartyController.do?ticket=" + ticket;
            String tokenUrl="https://zwfw.gat.gansu.gov.cn/zw_portal_api/third/expose/getAccessToken?serviceCode=BAXKBA";
            HttpRequest reqUserinfo= HttpUtil.createGet(userinfoUrl);
            HttpRequest reqToken= HttpUtil.createGet(tokenUrl);
            // 发起请求
            HttpResponse resToken= reqToken.execute();
            logger.info("获取token响应：{}",resToken);
            JSONObject jsonToken=JSON.parseObject(resToken.body());
            if(jsonToken.getString("code")!="200"){
                throw new IOException("获取token失败："+jsonToken.getString("message"));
            }
            // 添加请求头
            reqUserinfo.header("appToken", jsonToken.getString("result"));
            HttpResponse resUserinfo = reqUserinfo.execute();
            logger.info("获取用户信息响应：{}",resUserinfo);
            if(jsonToken.getString("code")!="200"){
                throw new IOException("获取用户信息失败："+jsonToken.getString("message"));
            }
            JSONObject jsonUserinfo=JSON.parseObject(resUserinfo.body());
            JSONObject result=JSON.parseObject(jsonUserinfo.getString("result"));
            Object userInfo = redisUtil.get("sso_natural:" + result.getString("sfzh"));
            String userName = null;
            if("0".equals(loginType)) {
                if (userInfo != null) {
                    userName = result.getString("sfzh");
                } else {
                    userName = singleLoginRpcProvider.saveLoginUserForNaturalPerson(result.getString("xm"),result.getString("sfzh"),result.getString("sjhm"));
                }
            }else {
                userName = singleLoginRpcProvider.saveLoginUserForLegalPerson(result.getString("xm"),result.getString("sfzh"),result.getString("sjhm"));
            }
            ThreadUtil.sleep(3000);
            request.setUserName(userName);
            request.setIpAddress(IPUtils.getIpAddress(req));
            response = this.identityRpcProvider.ssoLogin(request);
            //0212 自行招用保安员单位的备案;0213 保安服务公司设立分公司备案;0214 保安服务公司跨区域经营保安服务备案;0215 保安员证申领;0253 设立保安培训机构许可;0254 设立保安服务公司许可
            state = "021201".equals(state)?"v504":"021301".equals(state)?"":"021401".equals(state)?"v505":"021501".equals(state)?"v501":"025301".equals(state)?"v503":"025401".equals(state)?"v502":"";
            String type = "&type="+state;
            res.sendRedirect(configRpcProvider.getValueByKey("v5WebUrl") + "/static/signon/bjca.html?token=" + response.getToken()+type);
        } catch (Exception e) {
            pw.write("<br/>");
            pw.write("<h3>" + e.getMessage() + "</h3>");
        }
    }

}
