package com.bcxin.tenant.backend.requests;

import lombok.Getter;

import java.util.Collection;
@Getter
public class BatchRbacCategoryResourceRequest {
    private final Collection<CategoryRequest> categories;

    public BatchRbacCategoryResourceRequest(Collection<CategoryRequest> categories) {
        this.categories = categories;
    }

    public static BatchRbacCategoryResourceRequest create(Collection<CategoryRequest> categories) {
        return new BatchRbacCategoryResourceRequest(categories);
    }

    @Getter
    public static class CategoryRequest  {
        private final String id;
        private final String name;
        private final Collection<CategoryResourceRequest> resources;

        public CategoryRequest(String id, String name, Collection<CategoryResourceRequest> resources) {
            this.id = id;
            this.name = name;
            this.resources = resources;
        }

        public static CategoryRequest create(String id, String name, Collection<CategoryResourceRequest> resources) {
            return new CategoryRequest(id, name,resources);
        }
    }

    @Getter
    public static class CategoryResourceRequest {
        private final String id;
        private final String name;

        public CategoryResourceRequest(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static CategoryResourceRequest create(String id, String name) {
            return new CategoryResourceRequest(id, name);
        }
    }
}
