package com.bcxin.tenant.backend.components.extensions;

import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchRequestAbstract;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchType;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DepartValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DomainValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.UserValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueSnapshot;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
@Component
public class DirectlyDataExchangeComponent {
    private static final Logger logger = LoggerFactory.getLogger(DirectlyDataExchangeComponent.class);
    private static final Collection<String> parameterNames =
            Stream.of("uuid_nextid","name","organizeCode","id","registeredAddress",
                    "loginName","domainId","sex","birthdateText","certificateTypeValue","certificateNo",
                    "entryDateText","defaultDepartId","parentId",
                    "displayOrder").collect(Collectors.toList());

    //新建企业到从业单位
    private static String INSERT_ORGAN_TO_CYDW = "INSERT IGNORE INTO baibaodunflow.tlk_companyinformation (LASTMODIFIED, FORMNAME, CREATED, FORMID, ISTMP, APPLICATIONID, DOMAINID, " +
            " ITEM_companyName, ITEM_registerAddress, ITEM_registerAddressDetail, ITEM_officeAddress, ITEM_officeAddressDetail, ITEM_companyPhone, " +
            " ITEM_companyFax, ITEM_economicType, ITEM_companyType, ID, ITEM_isSub, ITEM_groupName, ITEM_groupDocumentType, ITEM_groupDocumentNO," +
            " ITEM_groupLegalPerson, ITEM_groupPhone, ITEM_legalPerson, ITEM_documentType, ITEM_documentID, ITEM_nationality, ITEM_legalPersonPhone," +
            " ITEM_registeredCapital, ITEM_fixedAssets, ITEM_annuaTurnover, ITEM_profitTaxes, ITEM_registerDocumentType, ITEM_registerID," +
            " ITEM_registerPhoto, ITEM_officeType, ITEM_securityServicePermitNo, ITEM_securityServicePhoto, ITEM_issuingSecurityService, " +
            " ITEM_issueServiceDate, ITEM_businessScope, ITEM_HRLevel, ITEM_armedEscortLevel, ITEM_securityPrecautions, ITEM_isRiskAssessment," +
            " ITEM_securityTrainPermitNo, ITEM_securityTrainPhoto, ITEM_issuingTrainPermit, ITEM_issueTrainDate, ITEM_trainScope, ITEM_SecurityNums," +
            " ITEM_domain_id, ITEM_companyStatus, ITEM_securityType, ITEM_isKeyProtectionUnits, ITEM_attendanceSiteType, ITEM_place_of_register_province_code," +
            " ITEM_place_of_business_province_code, ITEM_place_of_register_city_code, ITEM_place_of_business_city_code, ITEM_place_of_register_district_code," +
            " ITEM_place_of_business_district_code, ITEM_sec_manager, ITEM_sec_manager_phone, ITEM_sec_manager_id, ITEM_sec_manager_doc_type, ITEM_approval_number, ITEM_is_property)" +
            " VALUES (#{nowDate}, #{formName}, #{nowDate}, #{formId}, 0, #{applicationId},  #{domainId}, " +
            "  #{name}, #{registerAddress}, #{registerAddressDetail}, #{businessAddress}, #{businessAddressDetail}, #{telephone}, " +
            " #{fax}, #{economicType}, #{nature}, #{id}, #{type}, #{parentName}, #{parentCertificateType}, #{parentCertificateNumber}," +
            " #{parentLegalPersonName}, #{parentLegalPersonTelephone}, #{legalPersonName}, #{legalPersonCredentialType},#{legalPersonCredentialNumber},#{legalPersonNationality},#{legalPersonTelephone}," +
            "#{registeredCapital},#{fixedCapital},#{annualSalesVolume},#{annualProfitTax},#{certificateType},#{unifySocialCreditCode}," +
            "#{unifySocialCreditCodeFile},#{institutionalCode},#{securityServicePermitNumber},#{securityServicePermitAttachment},#{securityNameOfIssuingAuthority}," +
            "#{securityFirstIssueServicePermit},#{serviceScopeDescription},#{securityPreparednessRating},#{securityArmedRating},#{securitySafetyDefenseRating},#{isRiskAssessment}," +
            "#{trainServicePermitNumber},#{trainServicePermitAttachment},#{trainNameOfIssuingAuthority},#{trainFirstIssueServicePermit},#{trainContent},#{numberOfSecurityGuards}," +
            "#{itemDomainId},#{status},#{industryDetailType},#{isPublicSecuritySecurity},#{natureOfSelfRecruitedUnits},#{placeOfRegisterProvinceCode}," +
            "#{placeOfBusinessProvinceCode},#{placeOfRegisterCityCode},#{placeOfBusinessCityCode},#{placeOfRegisterDistrictCode}," +
            "#{placeOfBusinessDistrictCode},#{securityPersonName},#{securityPersonTelephone},#{securityPersonCredentialNumber},#{securityPersonCredentialType},#{securityApprovalNumber},#{isPropertyEnterprise});@!@!" +
            "INSERT IGNORE INTO baibaodunflow.tlk_setsupervise (LASTMODIFIED, FORMNAME, CREATED, FORMID, ISTMP, APPLICATIONID, DOMAINID, ITEM_domain_id," +
            " ITEM_registerAddress, ITEM_registerAddressID, ITEM_registerPoliceAddress, ITEM_registerPoliceAddressID, ITEM_registerPoliceIDIndex, ID) " +
            " VALUES (#{nowDate}, #{tlkSetsuperviseFormName}, #{nowDate}, #{tlkSetsuperviseFormId},0,#{tlkSetsuperviseApplicationId}, #{domainId}, #{itemDomainId}," +
            " (SELECT r.region_full_name FROM obpm2.sys_region r where r.id = #{superviseRegionCode}),#{superviseRegionCode},#{superviseDepartName}, " +
            " (SELECT td.id FROM organizationauth.tlk_departmentlevel td WHERE td.ITEM_CODE = #{superviseDepartId})," +
            " (SELECT td.ITEM_INDEXCODE FROM organizationauth.tlk_departmentlevel td WHERE td.ITEM_CODE = #{superviseDepartId}), #{tlkSetsuperviseId});";
    //更新企业到从业单位
    private static String UPDATE_ORGAN_TO_CYDW = "UPDATE baibaodunflow.tlk_companyinformation SET LASTMODIFIED=#{nowDate}, ITEM_companyName=#{name}, ITEM_registerAddress=#{registerAddress}," +
            " ITEM_registerAddressDetail=#{registerAddressDetail}, ITEM_officeAddress=#{businessAddress}, ITEM_officeAddressDetail=#{businessAddressDetail}," +
            " ITEM_companyPhone=#{telephone}, ITEM_companyFax=#{fax}, ITEM_economicType=#{economicType}, ITEM_companyType=#{nature}, ITEM_isSub=#{type}," +
            " ITEM_groupName=#{parentName}, ITEM_groupDocumentType=#{parentCertificateType}, ITEM_groupDocumentNO=#{parentCertificateNumber}," +
            " ITEM_groupLegalPerson=#{parentLegalPersonName}, ITEM_groupPhone=#{parentLegalPersonTelephone}, ITEM_legalPerson=#{legalPersonName}," +
            " ITEM_documentType=#{legalPersonCredentialType}, ITEM_documentID=#{legalPersonCredentialNumber}, ITEM_nationality=#{legalPersonNationality}," +
            " ITEM_legalPersonPhone=#{legalPersonTelephone}, ITEM_registeredCapital=#{registeredCapital}, ITEM_fixedAssets=#{fixedCapital}," +
            " ITEM_annuaTurnover=#{annualSalesVolume}, ITEM_profitTaxes=#{annualProfitTax}, ITEM_registerDocumentType=#{certificateType}," +
            " ITEM_registerID=#{unifySocialCreditCode}, ITEM_registerPhoto=#{unifySocialCreditCodeFile}, ITEM_officeType=#{institutionalCode}," +
            " ITEM_securityServicePermitNo=#{securityServicePermitNumber}, ITEM_securityServicePhoto=#{securityServicePermitAttachment}," +
            " ITEM_issuingSecurityService=#{securityNameOfIssuingAuthority}, ITEM_issueServiceDate=#{securityFirstIssueServicePermit}," +
            " ITEM_businessScope=#{serviceScopeDescription}, ITEM_HRLevel=#{securityPreparednessRating}, ITEM_armedEscortLevel=#{securityArmedRating}," +
            " ITEM_securityPrecautions=#{securitySafetyDefenseRating}, ITEM_isRiskAssessment=#{isRiskAssessment}, ITEM_securityTrainPermitNo=#{trainServicePermitNumber}," +
            " ITEM_securityTrainPhoto=#{trainServicePermitAttachment}, ITEM_issuingTrainPermit=#{trainNameOfIssuingAuthority}, ITEM_issueTrainDate=#{trainFirstIssueServicePermit}," +
            " ITEM_trainScope=#{trainContent}, ITEM_SecurityNums=#{numberOfSecurityGuards}, ITEM_companyStatus=#{status}," +
            " ITEM_securityType=#{industryDetailType}, ITEM_isKeyProtectionUnits=#{isPublicSecuritySecurity}, ITEM_attendanceSiteType=#{natureOfSelfRecruitedUnits}," +
            " ITEM_place_of_register_province_code=#{placeOfRegisterProvinceCode}, ITEM_place_of_business_province_code=#{placeOfBusinessProvinceCode}," +
            " ITEM_place_of_register_city_code=#{placeOfRegisterCityCode}, ITEM_place_of_business_city_code=#{placeOfBusinessCityCode}," +
            " ITEM_place_of_register_district_code=#{placeOfRegisterDistrictCode}, ITEM_place_of_business_district_code=#{placeOfBusinessDistrictCode}," +
            " ITEM_sec_manager=#{securityPersonName}, ITEM_sec_manager_phone=#{securityPersonTelephone}, ITEM_sec_manager_id=#{securityPersonCredentialNumber}," +
            " ITEM_sec_manager_doc_type=#{securityPersonCredentialType}, ITEM_approval_number=#{securityApprovalNumber}, ITEM_is_property=#{isPropertyEnterprise}" +
            " WHERE ID = #{id};@!@!UPDATE baibaodunflow.tlk_setsupervise SET  LASTMODIFIED=#{nowDate}," +
            " ITEM_registerAddress=(SELECT r.region_full_name FROM obpm2.sys_region r where r.id = #{superviseRegionCode})," +
            " ITEM_registerAddressID=#{superviseRegionCode}, ITEM_registerPoliceAddress=#{superviseDepartName}," +
            " ITEM_registerPoliceAddressID=(SELECT td.id FROM organizationauth.tlk_departmentlevel td WHERE td.ITEM_CODE = #{superviseDepartId})," +
            " ITEM_registerPoliceIDIndex=(SELECT td.ITEM_INDEXCODE FROM organizationauth.tlk_departmentlevel td WHERE td.ITEM_CODE = #{superviseDepartId}) WHERE ID = #{tlkSetsuperviseId};";

    private static String NEW_ORGAN = "insert into com_base_info(comId,comName,comCerNo,comCerType,tlkComId,createTime,updateTime,comTreeCode,regProvince,regCity,regArea,regAddress,comType,institutionType,industryType)  select " +
            " #{uuid_nextid},#{name},#{organizeCode},2,#{id},current_timestamp(),current_timestamp(),'',#{province},#{city},#{district},#{registeredAddress},'9','0102','01' from dual where not exists(select 1 from com_base_info where tlkComId = #{id})";

    private static String UPDATE_ORGAN = "UPDATE com_base_info set comName = #{name} ,comCerNo = #{organizeCode},updateTime = current_timestamp(),regProvince = #{province},regCity=#{city},regArea=#{district},regAddress=#{registeredAddress} where tlkComId = #{id}";

    private static String NEW_USER = "insert IGNORE  sys_user(user_id,login_name) " +
            " select #{uuid_nextid},#{loginName} from dual where not exists(select 1 from sys_user where login_name = #{loginName});" +
            "insert into per_base_info(sex,birthday,perType,perId,comId,userId,mobilePhone,name,idCardType,idCardNo,createTime,tlkPerId)" +
            "select #{sex},#{birthdate},#{perType},#{uuid_nextid},(select comId from (select comId from com_base_info where tlkComId = #{DomainId})u) as comid, #{uuid_nextid},#{loginName},#{name},#{certificateTypeValue},#{certificateNo},current_timestamp(),#{id} from dual  where not exists(select 1 from per_base_info  where tlkPerId = #{id});" +

            "insert into per_org_relation(entryDate,leaveDate,orgType,perOrgRelationId,perId,orgId,comId,createTime,tlkRelationId)" +
            "select #{entryDate},#{LeaveDate},2,#{uuid_nextid},(SELECT perId from per_base_info where tlkPerId = #{id}) as perId,(select departId from (select departId from com_depart where tlkDepartId = #{DefaultDepartId})u) as orgId,(select comId from (select comId from com_base_info where tlkComId = #{DomainId})u) as comId,current_timestamp(),#{id} from dual  where  not exists(select 1 from per_org_relation where tlkRelationId = #{id} )";

    private static String UPDATE_USER = "update sys_user set login_name = #{loginName} where login_name = #{loginName};" +
            "update per_base_info set sex = #{sex}, birthday =#{birthdate} ,perType = #{perType},mobilePhone = #{loginName},name = #{name},idCardType = #{certificateTypeValue},idCardNo = #{certificateNo} where tlkPerId = #{id};" +

            "update per_org_relation set entryDate=#{EntryDate},leaveDate = #{LeaveDate},orgId = (select departId from(select departId from com_depart where tlkDepartId = #{DefaultDepartId})u) where tlkRelationId = #{id};";

    private static String NEW_DEPART = "insert into com_depart (departId,comId,departName,parentDepartId,seq,isDelete,createTime,tlkDepartId,departTreeCode) " +
            "select #{uuid_nextid},(select comId from (select comId from com_base_info where tlkComId = #{DomainId})u) as comId,#{name},(select departId from(select departId from com_depart where tlkDepartId = #{parentId})u) as parentDepartId,#{displayOrder},0,current_timestamp(),#{id},#{departTreeCode} from dual " +
            " where not exists(select 1 from com_depart where tlkDepartId = #{id})";

    private static String UPDATE_DEPART = "update com_depart set departName = #{name},parentDepartId = (select departId from (select departId from com_depart where tlkDepartId = #{parentId})u),departTreeCode = #{departTreeCode} where tlkDepartId = #{id};";

    private final IdWorker idWorker;
    private final DataSource directlySharedAppDataSource;
    private final DataSource directlyOrganizationDataSource;

    public DirectlyDataExchangeComponent(IdWorker idWorker,
                                         @Qualifier("directlySharedAppDataSource") DataSource directlySharedAppDataSource,
                                         @Qualifier("directlyOrganizationDataSource") DataSource directlyOrganizationDataSource) {
        this.idWorker = idWorker;
        this.directlySharedAppDataSource = directlySharedAppDataSource;
        this.directlyOrganizationDataSource = directlyOrganizationDataSource;
    }

    public void execute(DispatchRequestAbstract dispatchRequest) {
        String sql = null;
        ValueSnapshot snapshot = dispatchRequest.getPostData();
        try {
            sql = getFormattedSql(snapshot, dispatchRequest);
            if (!StringUtils.hasLength(sql)) {
                return;
            }
            try (Connection connection = this.directlySharedAppDataSource.getConnection()) {
                boolean defaultAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                try (Statement statement = connection.createStatement()) {
                    for (String item : sql.split(";")) {
                        if (StringUtils.hasLength(item)) {
                            item = item.replaceAll("'null'", "null");
                            statement.addBatch(item);
                        }
                    }

                    statement.executeBatch();

                    connection.commit();
                } catch (Exception ex) {
                    connection.rollback();
                    if (ExceptionUtil.getStackMessage(ex).contains("Duplicate")) {
                        throw new IgnoreTenantException(String.format("该数据(%s)已存在", sql));
                    }

                    throw ex;
                } finally {
                    connection.setAutoCommit(defaultAutoCommit);
                }
            }
        } catch (Exception ex) {
            logger.error("【即将重试】 执行Jdbc分发中的执行运行机制Sql={},异常:{}",sql,ex);
            throw new BadTenantException(ExceptionUtil.getStackMessage(ex), ex);
        }
    }

    /**
     * description: 企业注册同步从业单位
     * author: linchunpeng
     * date:  2023-05-30 17:11
     */
    public void executeObpm2ToCydw(DispatchRequestAbstract dispatchRequest) {
        String sql = null;
        ValueSnapshot snapshot = dispatchRequest.getPostData();
        try {
            sql = getSqlObpm2ToCydw(snapshot, dispatchRequest);
            if (!StringUtils.hasLength(sql)) {
                return;
            }
            log.error("企业注册同步从业单位，脚本：{}", sql);
            try (Connection connection = this.directlyOrganizationDataSource.getConnection()) {
                boolean defaultAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                try (Statement statement = connection.createStatement()) {
                    for (String item : sql.split("@!@!")) {
                        if (StringUtils.hasLength(item)) {
                            item = item.replace("'null'", "null");
                            item = item.replace("'NULL'", "null");
                            statement.addBatch(item);
                        }
                    }
                    statement.executeBatch();
                    connection.commit();
                } catch (Exception ex) {
                    connection.rollback();
                    log.error("企业注册同步从业单位出错，脚本：{}，异常：{}", sql, ex.getMessage(), ex);
                    if (ExceptionUtil.getStackMessage(ex).contains("Duplicate")) {
                        throw new IgnoreTenantException(String.format("该数据(%s)已存在", sql));
                    }
                    throw ex;
                } finally {
                    connection.setAutoCommit(defaultAutoCommit);
                }
            }
        } catch (Exception ex) {
            log.error("【即将重试】企业注册同步从业单位出错，脚本：{}，异常：{}", sql, ex.getMessage(), ex);
        }
    }

    private String getFormattedSql(ValueSnapshot snapshot, DispatchRequestAbstract dispatchRequest) {
        String sql = null;
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("uuid_nextid", idWorker.nextId());

        if (snapshot instanceof DomainValueSnapshot) {
            sql = DispatchType.Created == dispatchRequest.getDispatchType() ? NEW_ORGAN : UPDATE_ORGAN;
            DomainValueSnapshot domainValueSnapshot = (DomainValueSnapshot) snapshot;
            parameters.put("id", domainValueSnapshot.getId());
            parameters.put("name", domainValueSnapshot.getName());
            parameters.put("certificate", domainValueSnapshot.getCertificate());
            parameters.put("organizeCode", domainValueSnapshot.getOrganizeCode());
            parameters.put("registeredAddress", domainValueSnapshot.getOrganizedAddress());
            parameters.put("organizedAddress", domainValueSnapshot.getRegisteredAddress());
            parameters.put("province", domainValueSnapshot.getPlaceOfRegisterProvinceCode());
            parameters.put("city", domainValueSnapshot.getPlaceOfRegisterCityCode());
            parameters.put("district", domainValueSnapshot.getPlaceOfRegisterDistrictCode());
        }

        if (snapshot instanceof DepartValueSnapshot) {
            sql = DispatchType.Created == dispatchRequest.getDispatchType() ? NEW_DEPART : UPDATE_DEPART;

            DepartValueSnapshot departValueSnapshot = (DepartValueSnapshot) snapshot;
            parameters.put("id", departValueSnapshot.getId());
            parameters.put("name", departValueSnapshot.getName());
            parameters.put("code", departValueSnapshot.getCode());
            parameters.put("displayOrder", departValueSnapshot.getDisplayOrder());
            parameters.put("createdTime", departValueSnapshot.getCreatedTime());
            parameters.put("domainId", departValueSnapshot.getDomainId());
            parameters.put("parentId", departValueSnapshot.getParentId());
            parameters.put("departTreeCode", departValueSnapshot.getDepartTreeCode());
        }

        if (snapshot instanceof UserValueSnapshot) {
            sql = DispatchType.Created == dispatchRequest.getDispatchType() ? NEW_USER : UPDATE_USER;

            UserValueSnapshot userValueSnapshot = (UserValueSnapshot) snapshot;
            parameters.put("id", userValueSnapshot.getId());
            parameters.put("name", userValueSnapshot.getName());
            parameters.put("DomainId", userValueSnapshot.getDomainId());
            parameters.put("CertificateStatusValue", userValueSnapshot.getCertificateStatusValue());
            parameters.put("CertificateStatus", userValueSnapshot.getCertificateStatus());
            parameters.put("CertificateTypeValue", userValueSnapshot.getCertificateTypeValue());
            parameters.put("Birthdate", userValueSnapshot.getBirthdate());
            parameters.put("CertificateNo", userValueSnapshot.getCertificateNo());
            parameters.put("ConnectedSelectedDepartIds", userValueSnapshot.getConnectedSelectedDepartIds());
            parameters.put("DefaultDepartId", userValueSnapshot.getDefaultDepartId());
            parameters.put("DomainUser", userValueSnapshot.getDomainUser());
            parameters.put("Email", userValueSnapshot.getEmail());
            parameters.put("EntryDate", userValueSnapshot.getEntryDate());
            parameters.put("LeaveDate", userValueSnapshot.getLeaveDate());
            parameters.put("FaceImage", userValueSnapshot.getFaceImage());
            parameters.put("IdCardFrontUrl", userValueSnapshot.getIdCardFrontUrl());
            parameters.put("IdCardReverseUrl", userValueSnapshot.getIdCardReverseUrl());
            parameters.put("IdNumber", userValueSnapshot.getIdNumber());
            parameters.put("IdType", userValueSnapshot.getIdType());
            parameters.put("JsonPicture", userValueSnapshot.getJsonPicture());
            parameters.put("Level", userValueSnapshot.getLevel());
            parameters.put("LoginName", userValueSnapshot.getLoginName());
            parameters.put("Password", userValueSnapshot.getPassword());
            parameters.put("Sex", userValueSnapshot.getSex());
            parameters.put("Telephone", userValueSnapshot.getTelephone());
            parameters.put("isDimission", userValueSnapshot.isIsDimission());
            parameters.put("status", userValueSnapshot.isStatus());
            parameters.put("BirthdateText", userValueSnapshot.getBirthdateText());
            parameters.put("EntryDateText", userValueSnapshot.getEntryDateText());
            parameters.put("LeaveDateText", userValueSnapshot.getLeaveDateText());
            if (userValueSnapshot.getOccupationType() != null) {
                if (userValueSnapshot.getOccupationType() == OccupationType.Normal) {
                    parameters.put("perType", "010003");
                } else if (userValueSnapshot.getOccupationType() == OccupationType.SecurityGuard) {
                    parameters.put("perType", "010001");
                } else {
                    parameters.put("perType", "010002");
                }
            }


            if (userValueSnapshot.getExtendMap() != null) {
                for (String key : userValueSnapshot.getExtendMap().keySet()) {
                    parameters.put(key, snapshot.getAdditionalParams().get(key));
                }
            }
        }

        if (snapshot.getAdditionalParams() != null) {
            for (String key : snapshot.getAdditionalParams().keySet()) {
                parameters.put(key, snapshot.getAdditionalParams().get(key));
            }
        }

        sql = setParameters(sql, parameters);

        return sql;
    }


    /**
     * description: 企业注册同步从业单位
     * author: linchunpeng
     * date:  2023-05-30 15:51
     */
    private String getSqlObpm2ToCydw(ValueSnapshot snapshot, DispatchRequestAbstract dispatchRequest) {
        String sql = null;
        Map<String, Object> parameters = new HashMap<>();

        sql = DispatchType.Created == dispatchRequest.getDispatchType() ? INSERT_ORGAN_TO_CYDW : UPDATE_ORGAN_TO_CYDW;
        DomainValueSnapshot domainValueSnapshot = (DomainValueSnapshot) snapshot;

        parameters.put("nowDate", new Date());
        parameters.put("formName", "企业管理/企业信息/CompanyInformation");
        parameters.put("formId", "__AOkTvsah9VLicJhQ1FO");
        parameters.put("applicationId", "__DXZvc8mnEmDqMARhK7G");
        parameters.put("domainId", domainValueSnapshot.getId());
        parameters.put("name", domainValueSnapshot.getName());
        parameters.put("registerAddress", domainValueSnapshot.getRegisteredAddress());
        parameters.put("registerAddressDetail", domainValueSnapshot.getRegisteredAddressDetail());
        parameters.put("businessAddress", domainValueSnapshot.getOrganizedAddress());
        parameters.put("businessAddressDetail", domainValueSnapshot.getOrganizedAddressDetail());
        parameters.put("telephone", domainValueSnapshot.getTelephone());
        parameters.put("fax", domainValueSnapshot.getFax());
        parameters.put("economicType", domainValueSnapshot.getEconomicType());
        parameters.put("nature", domainValueSnapshot.getNature());
        parameters.put("id", domainValueSnapshot.getId().concat("--__AOkTvsah9VLicJhQ1FO"));
        parameters.put("type", domainValueSnapshot.getType());
        parameters.put("parentName", domainValueSnapshot.getParentName());
        parameters.put("parentCertificateType", domainValueSnapshot.getParentCertificateType());
        parameters.put("parentCertificateNumber", domainValueSnapshot.getParentCertificateNumber());
        parameters.put("parentLegalPersonName", domainValueSnapshot.getParentLegalPersonName());
        parameters.put("parentLegalPersonTelephone", domainValueSnapshot.getParentLegalPersonTelephone());
        parameters.put("legalPersonName", domainValueSnapshot.getLegalPersonName());
        parameters.put("legalPersonCredentialType", domainValueSnapshot.getLegalPersonCredentialType());
        parameters.put("legalPersonCredentialNumber", domainValueSnapshot.getLegalPersonCredentialNumber());
        parameters.put("legalPersonNationality", domainValueSnapshot.getLegalPersonNationality());
        parameters.put("legalPersonTelephone", domainValueSnapshot.getLegalPersonTelephone());
        parameters.put("registeredCapital", domainValueSnapshot.getRegisteredCapital());
        parameters.put("fixedCapital", domainValueSnapshot.getFixedCapital());
        parameters.put("annualSalesVolume", domainValueSnapshot.getAnnualSalesVolume());
        parameters.put("annualProfitTax", domainValueSnapshot.getAnnualProfitTax());
        parameters.put("certificateType", domainValueSnapshot.getCertificateType());
        parameters.put("unifySocialCreditCode", domainValueSnapshot.getOrganizeCode());
        parameters.put("unifySocialCreditCodeFile", domainValueSnapshot.getCertificate());
        parameters.put("institutionalCode", domainValueSnapshot.getInstitutionalCode());
        parameters.put("securityServicePermitNumber", null);
        parameters.put("securityServicePermitAttachment", null);
        parameters.put("securityNameOfIssuingAuthority", null);
        parameters.put("securityFirstIssueServicePermit", null);
        parameters.put("trainServicePermitNumber", null);
        parameters.put("trainServicePermitAttachment", null);
        parameters.put("trainNameOfIssuingAuthority", null);
        parameters.put("trainFirstIssueServicePermit", null);
        if ("0102".equals(domainValueSnapshot.getInstitutionalCode())) {
            parameters.put("securityServicePermitNumber", domainValueSnapshot.getServicePermitNumber());
            parameters.put("securityServicePermitAttachment", domainValueSnapshot.getServicePermitAttachment());
            parameters.put("securityNameOfIssuingAuthority", domainValueSnapshot.getNameOfIssuingAuthority());
            parameters.put("securityFirstIssueServicePermit", domainValueSnapshot.getFirstIssueServicePermit());
        } else if ("0103".equals(domainValueSnapshot.getInstitutionalCode())) {
            parameters.put("trainServicePermitNumber", domainValueSnapshot.getServicePermitNumber());
            parameters.put("trainServicePermitAttachment", domainValueSnapshot.getServicePermitAttachment());
            parameters.put("trainNameOfIssuingAuthority", domainValueSnapshot.getNameOfIssuingAuthority());
            parameters.put("trainFirstIssueServicePermit", domainValueSnapshot.getFirstIssueServicePermit());
        }
        parameters.put("serviceScopeDescription", domainValueSnapshot.getServiceScope());
        parameters.put("securityPreparednessRating", domainValueSnapshot.getSecurityPreparednessRating());
        parameters.put("securityArmedRating", domainValueSnapshot.getSecurityArmedRating());
        parameters.put("securitySafetyDefenseRating", domainValueSnapshot.getSecuritySafetyDefenseRating());
        parameters.put("isRiskAssessment", domainValueSnapshot.getIsRiskAssessment());

        parameters.put("trainContent", domainValueSnapshot.getTrainContent());
        parameters.put("numberOfSecurityGuards", domainValueSnapshot.getNumberOfSecurityGuards());
        parameters.put("itemDomainId", domainValueSnapshot.getId());
        parameters.put("status", domainValueSnapshot.getStatus() == null ? null : domainValueSnapshot.getStatus().getTypeName());
        parameters.put("industryDetailType", domainValueSnapshot.getIndustryDetailType());
        parameters.put("isPublicSecuritySecurity", domainValueSnapshot.getIsPublicSecuritySecurity());
        parameters.put("natureOfSelfRecruitedUnits", domainValueSnapshot.getNatureOfSelfRecruitedUnits());
        parameters.put("placeOfRegisterProvinceCode", domainValueSnapshot.getPlaceOfRegisterProvinceCode());
        parameters.put("placeOfBusinessProvinceCode", domainValueSnapshot.getPlaceOfBusinessProvinceCode());
        parameters.put("placeOfRegisterCityCode", domainValueSnapshot.getPlaceOfRegisterCityCode());
        parameters.put("placeOfBusinessCityCode", domainValueSnapshot.getPlaceOfBusinessCityCode());
        parameters.put("placeOfRegisterDistrictCode", domainValueSnapshot.getPlaceOfRegisterDistrictCode());
        parameters.put("placeOfBusinessDistrictCode", domainValueSnapshot.getPlaceOfBusinessDistrictCode());
        parameters.put("securityPersonName", domainValueSnapshot.getSecurityPersonName());
        parameters.put("securityPersonTelephone", domainValueSnapshot.getSecurityPersonTelephone());
        parameters.put("securityPersonCredentialNumber", domainValueSnapshot.getSecurityPersonCredentialNumber());
        parameters.put("securityPersonCredentialType", domainValueSnapshot.getSecurityPersonCredentialType());
        parameters.put("securityApprovalNumber", domainValueSnapshot.getSecurityApprovalNumber());
        parameters.put("isPropertyEnterprise", domainValueSnapshot.getIsPropertyEnterprise());
        parameters.put("tlkSetsuperviseFormName", "企业管理/企业信息/SetSupervise");
        parameters.put("tlkSetsuperviseFormId", "__DRWRVHekZL0pUfzfTwb");
        parameters.put("tlkSetsuperviseApplicationId", "__DXZvc8mnEmDqMARhK7G");
        parameters.put("superviseRegionCode", domainValueSnapshot.getPlaceOfSuperviseCode());
        parameters.put("superviseDepartName", domainValueSnapshot.getSuperviseDepartName());
        parameters.put("superviseDepartId", domainValueSnapshot.getSuperviseDepartId());
        parameters.put("tlkSetsuperviseId", domainValueSnapshot.getId().concat("--__DRWRVHekZL0pUfzfTwb"));

        sql = setParametersNotCase(sql, parameters);

        return sql;
    }


    private String setParameters(String sql, Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (value instanceof Date) {
                value = String.format("'%s'", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(value));
            } else if (value instanceof Boolean) {
                value = ((boolean) value) ? 1 : 0;
            } else if (value instanceof Integer) {
                value = ((Integer) value).intValue();
            } else {
                if (value != null) {
                    value = String.valueOf(value).replace("'", "''");
                    value = String.format("'%s'", value);
                }
            }

            String replacedKey = "#{" + key.toLowerCase(Locale.ROOT) + "}";
            if (value == null) {
                sql = sql.toLowerCase(Locale.ROOT).replace(String.format("'%s'", replacedKey), "NULL");
                sql = sql.toLowerCase(Locale.ROOT).replace(replacedKey, "NULL");
            } else {
                String sValue = String.valueOf(value);
                sql = sql.toLowerCase(Locale.ROOT).replace(replacedKey, sValue);
            }
        }
        return sql;
    }

    private String setParametersNotCase(String sql, Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (value instanceof Date) {
                value = String.format("'%s'", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(value));
            } else if (value instanceof Boolean) {
                value = ((boolean) value) ? 1 : 0;
            } else if (value instanceof Integer) {
                value = ((Integer) value).intValue();
            } else {
                if (value != null) {
                    value = String.valueOf(value).replace("'", "''");
                    value = String.format("'%s'", value);
                }
            }

            String replacedKey = "#{" + key + "}";
            if (value == null) {
                sql = sql.replace(String.format("'%s'", replacedKey), "NULL");
                sql = sql.replace(replacedKey, "NULL");
            } else {
                String sValue = String.valueOf(value);
                sql = sql.replace(replacedKey, sValue);
            }
        }
        return sql;
    }
}