/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures;

import com.bcxin.Infrastructures.InjectResolver;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TenantContext {
    private static volatile TenantContext _tenantContext;
    private InjectResolver injectResolver;
    private static final ThreadLocal<Map<Object, Object>> attachmentsContainer;
    private static final TenantUserContext userContext;

    private TenantContext() {
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantContext getInstance() {
        if (_tenantContext != null) return _tenantContext;
        Class<TenantContext> clazz = TenantContext.class;
        synchronized (TenantContext.class) {
            if (_tenantContext != null) return _tenantContext;
            _tenantContext = new TenantContext();
            _tenantContext.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _tenantContext;
        }
    }

    public void setInjectResolver(InjectResolver injectResolver) {
        this.injectResolver = injectResolver;
    }

    public <T> T resolve(Class<T> tClass) {
        if (this.injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory\u672a\u6b63\u786e\u521d\u59cb\u5316");
        }
        return this.injectResolver.resolve(tClass);
    }

    public <T> Collection<T> resolveAll(Class<T> tClass) {
        if (this.injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory\u672a\u6b63\u786e\u521d\u59cb\u5316");
        }
        return this.injectResolver.resolveAll(tClass);
    }

    public void setValue(Object key, Object value) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        if (attachments == null) {
            attachments = new HashMap<Object, Object>();
        }
        if (value == null) {
            attachments.remove(key);
        } else {
            attachments.put(key, value);
        }
        attachmentsContainer.set(attachments);
    }

    public <T> T getValueAndRemove(Object key) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        if (attachments == null) {
            return null;
        }
        Object data = attachments.get(key);
        this.setValue(key, null);
        return (T)data;
    }

    public TenantUserContext getUserContext() {
        return userContext;
    }

    static {
        attachmentsContainer = new ThreadLocal();
        userContext = new TenantUserContext();
    }
}

