package com.bcxin.ferry.strategy.callback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.service.FerryTaskService;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收明细文件回调策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveDetailFileCallbackStrategy implements ReceiveCallbackStrategy {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Async
    @Override
    public void handle(String data) {
        FerryFileCallbackDto callbackDto = JSONObject.parseObject(data, FerryFileCallbackDto.class);
        //修改明细文件状态
        log.info("修改单个摆渡明细文件结果");
        Long taskId = ferryTaskService.updateFerryDetailFileResult(callbackDto);
        //修改任务状态为：摆渡明细文件结束
        if (taskId != null) {
            log.info("根据明细文件状态，修改任务状态，taskId：{}", taskId);
            ferryTaskService.updateFerryDetailFileComplete(taskId);
        } else {
            log.info("文件不存在，对应的任务也不存在");
        }
    }
}
