package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.service.FerryErrorInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：扫描异常情况
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class ScanErrorInfo {

    @Autowired
    private FerryErrorInfoService ferryErrorInfoService;

    @Scheduled(cron = "${scheduling-config.scan-error-info.cron}")
    public void scanErrorInfo() {
        log.info("===================================定时扫描异常情况===================================");
        ferryErrorInfoService.scanErrorInfo();
        log.info("===================================扫描异常情况结束===================================");
    }

}
