package com.bcxin.ferry.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * description：治综边界服务配置
 * author：linchunpeng
 * date：2024/3/8
 */
@Data
@Component
@ConfigurationProperties(prefix = "boundary-server-config")
public class BoundaryServerConfig {

    //请求授权码
    private String roleCode;
    //最大文件大小，单位：子节
    private Long maxFileSize;
    //接口配置
    private Api api;

    @Data
    public static class Api {
        //发送文件或数据接口
        private String sendUrl;
        //查询任务接口
        private String queryUrl;
    }

}
