package com.bcxin.identity.domains.components.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

@Getter
public class ForgetPasswordActionExecuteCommand extends CommandAbstract {
    private final String loginName;
    private final String mobile;
    private final String name;
    private final String dataNoe;
    private final String dataTow;
    private final UserCheckedStatus userCheckedStatus;

    public String getDefaultPassword()
    {
        String defaultPassword = this.getMobile();
        if (StringUtils.hasLength(defaultPassword) && defaultPassword.length() > 0) {
            defaultPassword = defaultPassword.substring(defaultPassword.length() - 6);
        }

        return defaultPassword;
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getMobile())) {
            throw new NotSupportTenantException("手机号无效！");
        }
    }

    public ForgetPasswordActionExecuteCommand(
            UserCheckedStatus userCheckedStatus,String loginName,
            String mobile, String name,String dataNoe, String dataTow) {
        this.loginName = loginName;
        this.mobile = mobile;
        this.name = name;
        this.dataNoe = dataNoe;
        this.dataTow = dataTow;
        this.userCheckedStatus = userCheckedStatus;
    }

    public static ForgetPasswordActionExecuteCommand create(
            UserCheckedStatus userCheckedStatus,
            String loginName,String mobile, String name,String dataNoe, String dataTow) {
        return new ForgetPasswordActionExecuteCommand(userCheckedStatus, loginName,mobile, name, dataNoe, dataTow);
    }
}
